# ----------------------------------------------------------
# AdvaS Advanced Search 
# basic list functions
#
# (C) 2002 - 2005 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
# ----------------------------------------------------------

# changed 2004-11-16

import string

def count_words (words):
	"count words given in a list, return word and its frequency"

	# start with an empty list
	list = {}

	# check each word
	for i in words:
		# assume a new item
		frequency = 0
		
		# word already in list?
		if list.has_key(i):
			# get frequency
			frequency = list[i]

		# increment frequency by one
		frequency = frequency + 1

		# save frequency , update list
		list[i] = frequency
	# end for
		
	# return list of words (frequency list)
	return list

def merge_lists (*lists):
	"merge lists of words"

	# start with an empty list
	newlist = {}

	# check each list
	for current_list in lists:

		# get number of keys
		key = current_list.keys()

		for item in key:
			# assume a new item
			frequency = 0
			
			# item already in newlist?
			if newlist.has_key(item):
				# get frequency
				frequency = newlist[item]

			# increment frequency
			frequency = frequency + current_list[item]

			# save frequency , update newlist
			newlist[item] = frequency
		# end for
	# end for

	# return combined list
	return newlist

def merge_lists_idf (*lists):
	"merge lists of words for calculating idf"

	# start with an empty list
	newlist = {}

	# check each list
	for current_list in lists:

		# get number of keys
		key = current_list.keys()

		for item in key:
			# assume a new item
			frequency = 1
			
			# item already in newlist?
			if newlist.has_key(item):
				# get frequency
				frequency = newlist[item] + 1

			# save frequency , update newlist
			newlist[item] = frequency
		# end for
	# end for

	# return combined list
	return newlist

def compact_list (original):
	"merges items appearing more than once"

	# define empty list
	newlist = {}

	# get number of keys
	key = original.keys()

	for j in key:
		# get item
		item = string.lower(string.strip(j))

		# assume a new item
		frequency = 0

		# item already in newlist?
		if newlist.has_key(item):
			# get frequency
			frequency = newlist[item]
		# end if

		# add frequencies
		frequency = frequency + original[j]

		# save frequency , update newlist
		newlist[item] = frequency
	# end for

	# return new list
	return newlist

def remove_items (original, remove):
	"remove the items from the original list"

	# start with the original list
	newlist = original

	# get number of items to be removed
	key = remove.keys()

	for item in key:
		# item in original list?
		if newlist.has_key(item):
			# remove item
			del newlist[item]
		# end if
	# end for

	# return newlist
	return newlist

def convert_dictionary_into_list (original):
	"converts a dictionary into a list"

	# define result
	result = []

	# get number of keys
	key = original.keys()
	for item in key:
		result.append(item)
	# end for

	return result

def convert_list_into_dictionary (original, init_value):
	"converts a list into a dictionary"

	# define result
	result = {}

	# get size of the list
	list_size = len(original)
	for item in range(list_size):
		left_value = original[item]
		result[left_value] = init_value
	# end for	

	return result


