
# ----------------------------------------------------------
# advas
# advanced search algorithms implemented as a python class
#
# (C) 2003 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
#
# example for testing the n gram stemmer
#
# ----------------------------------------------------------

# changed 2003-05-14

# import advas class
from advas_oo import Advas

# create Advas object
a = Advas()

# a line of text
# line = "footnote, footpath, footman, footing, footie, foothold, footprint, footmark, foodstep, footwork, footer, footage, football, footballer, footlights, footrest, footwear, footstool, foot"
line = "foreign, foreigner, foreleg, forelock, foreman, foremost, forename, forenoon, forensic, foresee, foreseeable, forest, forestry, forever, forge, forger, forgery, forget, forgot"
print "text: " + line + "\n"

# split text
a.set_line(line)
a.split_line()
words = a.get_words()
print words

# call n-gram stemmer
# use bigramms (2)
# quality of 80% (0.8)
result = a.ngram_stemmer (words, 2, 0.8)

print result
