/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <addresslineedit.h>
#include <ataddressbook.h>
#include <addresslistclass.h>
#include <addressclass.h>

#define IDSTRING "AddressLineEdit: "

//#define DEBUG_ALE

AddressLineEdit::AddressLineEdit(QWidget *parent, const char *name):ELineEdit(parent, name)
{
	_updateCache=false;
	initMode(AddressBook::Contacts | AddressBook::History);
	connect(this,SIGNAL(textChanged(const QString &)),
		this, SLOT(requestCompletion(const QString &)));
}

void AddressLineEdit::initMode( int mode )
{
	_mode=mode;
}

AddressListClass AddressLineEdit::updateAddresses()
{
	_myList.clear();
	// build the list from the text typed in...
	QStringList its=QStringList::split(QRegExp("[,;]"), lineEdit()->text());
	QStringList newItems;
	for(int i=0;i<its.count();i++)
	{
		newItems=AddressBook::thisInstance()->getRealEntry(its[i].stripWhiteSpace());
		if(newItems.count()==0)
		{
			//to add in cache a new address
			QString txt=its[i].simplifyWhiteSpace().stripWhiteSpace();
			if(txt.find("@")!=-1)
			{
				if(updateCache())
					AddressBook::thisInstance()->addHistoryAddress(txt);
				newItems.append(txt);
				addItems(newItems);
			}
		}
		else
		{
			addItems(newItems);
		}
	}
	return _myList;
}

void AddressLineEdit::addItems(QStringList items)
{
	for(int i=0;i<items.count();i++)
	{
		printf(IDSTRING"Adding item <%s>\n", (const char *)items[i]);
		_myList.addAddress(new AddressClass((const char *)items[i]));
	}
}

void AddressLineEdit::setAddresses(AddressListClass alc)
{
	_myList=alc;
	lineEdit()->setText((const char *)alc.toQCString());
}

void AddressLineEdit::setUpdateCache(bool item)
{
	_updateCache=item;
}

bool AddressLineEdit::updateCache()
{
	return _updateCache;
}

void AddressLineEdit::requestCompletion(const QString &str)
{
	AddressBook *inst=AddressBook::thisInstance();
//	QStringList results=inst->getEntries(inst->completeNames(str, _mode));
	QStringList results;
	QStringList names, tn;
	QStringList brackets, tb;
#ifdef DEBU_ALE
	printf(IDSTRING"Adding Contacts\n");
#endif
	if(_mode & AddressBook::Contacts)
		results=inst->completeNames(str, AddressBook::Contacts);
//		results=inst->getEntries(inst->completeNames(str, AddressBook::Contacts));
#ifdef DEBU_ALE
	printf(IDSTRING"Adding History\n");
#endif
	if(_mode & AddressBook::History)
		results+=inst->completeNames(str, AddressBook::History);
	for(int i=0;i<results.count();i++)
	{
#ifdef DEBU_ALE
		printf(" ALE: %d = |%s|\n", i, (const char *)results[i]);
#endif
	}
	setCompletions(results);
}

QString AddressLineEdit::translateString (QString str)
{
//	if(AddressBook::thisInstance()->isContact(str))
//		return AddressBook::thisInstance()->getEntries(str)[0];
	return str;
}
