/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __Has_ContactsConfig__
#define __Has_ContactsConfig__

#include <contactsconfigbase.h>

class ContactsConfig : public ContactsConfigBase
{
	Q_OBJECT
	public:
		ContactsConfig(QWidget *parent, const char *name=0);
	public slots:
		virtual void load();
    virtual void sync(bool visible=false);
    virtual void defaultFieldsClicked();
    virtual void emailClicked();
    virtual void hCityClicked();
    virtual void hCodeClicked();
    virtual void hExtendedClicked();
    virtual void hPoBoxClicked();
    virtual void hRegionClicked();
    virtual void hStreetClicked();
    virtual void nameClicked();
    virtual void hCountryClicked();
    virtual void otherClicked();
    virtual void phoneChanged(const QString &);
    virtual void prefixClicked();
    virtual void suffixClicked();
    virtual void surnameClicked();
    virtual void wCityClicked();
    virtual void wCodeClicked();
    virtual void wCountryClicked();
    virtual void wExtendedClicked();
    virtual void wPoBoxClicked();
    virtual void wRegionClicked();
    virtual void wStreetClicked();
	signals:
		void changed();
		void noChanged();
	private:
		void loadName(QString);
		void loadWork(QString);
		void loadHome(QString);
		void loadEmail(QString);
		void loadPhone(QString);
};

#endif
