#ifndef IMAP4WIZARDBASE_H
#define IMAP4WIZARDBASE_H

#include <qvariant.h>
#include <qwizard.h>
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QCheckBox;
class QLabel;
class QLineEdit;
class QWidget;

class IMAP4WizardBase : public QWizard
{
    Q_OBJECT

public:
    IMAP4WizardBase( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~IMAP4WizardBase();

    QWidget* userInfo;
    QLineEdit* nameEdit;
    QLineEdit* emailEdit;
    QLineEdit* replyEdit;
    QLabel* TextLabel16;
    QLabel* TextLabel17;
    QLabel* TextLabel15;
    QLabel* TextLabel1;
    QLineEdit* accountNameEdit;
    QWidget* imap4Widget;
    QLabel* TextLabel18;
    QLabel* TextLabel19;
    QLineEdit* portEdit;
    QLineEdit* imap4Edit;
    QLineEdit* userEdit;
    QLabel* TextLabel20;
    QLineEdit* passEdit;
    QLabel* TextLabel21;
    QCheckBox* passCheck;
    QCheckBox* syncCheck;
    QCheckBox* sortCheck;
    QCheckBox* leaveCheck;
    QWidget* SMTP;
    QLabel* TextLabel22;
    QLineEdit* smtpPortEdit;
    QLineEdit* smtpEdit;
    QLabel* TextLabel23;

public slots:
    virtual void accountNameChanged(const QString &);
    virtual void emailChanged(const QString &);
    virtual void leaveClicked();
    virtual void nameChanged(const QString &);
    virtual void passChanged(const QString &);
    virtual void passClicked();
    virtual void imap4Changed(const QString &);
    virtual void imap4PortChanged(const QString &);
    virtual void replyChanged(const QString &);
    virtual void smtpChanged(const QString &);
    virtual void smtpPortChanged(const QString &);
    virtual void sortClicked();
    virtual void syncClicked();
    virtual void userChanged(const QString &);

protected:
    QGridLayout* userInfoLayout;
    QGridLayout* imap4Layout;
    QGridLayout* SMTPLayout;
};

#endif


