/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qcheckbox.h>
#include <qlineedit.h>
#include <kconfig.h>

#include <mailconfigbase.h>
#include <mailconfig.h>
#include <miscfunctions.h>

extern KConfig *GlobalConfig;

MailConfig::MailConfig(QWidget *parent, const char *name=0) : MailConfigBase(parent, name)
{
	load();
}
void MailConfig::load()
{
	GlobalConfig->setGroup("Read Options");
	secondsEdit->setText(GlobalConfig->readEntry("Read timeout"));
	receivedCheck->setChecked(GlobalConfig->readEntry("Display received")=="Yes");
	moveCheck->setChecked(GlobalConfig->readEntry("Deleted to trash")=="Yes");
	updateComboBox(forwardCombo, GlobalConfig->readEntry("Forward type"));
}

void MailConfig::sync(bool visible=false)
{
	bool doSync=(!visible && isVisible()) | (visible);
	if(!doSync)
		return;
		
	QString test;
	GlobalConfig->setGroup("Read Options");
	GlobalConfig->writeEntry("Read timeout", test.sprintf("%d",secondsEdit->text().toInt()));
	GlobalConfig->writeEntry("Display received", ((receivedCheck->isChecked())?"Yes":"No"));
	GlobalConfig->writeEntry("Deleted to trash", ((moveCheck->isChecked())?"Yes":"No"));
	GlobalConfig->writeEntry("Forward type", forwardCombo->currentText());
	emit(noChanged());
}
void MailConfig::moveClicked()
{
	emit(changed());
}
void MailConfig::forwardChanged(const QString &)
{
	emit(changed());
}
void MailConfig::receivedClicked()
{
	emit(changed());
}
void MailConfig::secondsChanged(const QString &)
{
	emit(changed());
}
