/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <mailobj.h>
#include <qcstring.h>
#include <qmap.h>
#include <conversions.h>
#include <vcacheobject.h>
#include <vmailattribute.h>
#include <qregexp.h>

MailObject::MailObject(QString _path):VObject(_path)
{
  sync();
}

MailObject::MailObject(QString _path, QByteArray& _data):VObject(_path)
{
  if( !_data || !_data.size() )
    sync();
  else
    _narrow( _data);
}

bool MailObject::sync()
{
	VCacheObject *cacheObj=parentFolder()->entryCacheBlock();
	
	if(cacheObj)
	{
		QByteArray cacheData=cacheObj->cacheData();
		QDataStream cstream(cacheData, IO_ReadOnly);
		QMap<QString, QByteArray> cmap;
		cstream>>cmap;
		QByteArray objCache=cmap[name()];
		QDataStream dstream(objCache, IO_ReadOnly);
		
		Q_UINT8 red, green, blue;
		QString strSentDate, strReceivedDate, strFrom;
		QStringList strTo;
		dstream>>_status>>_extendedStatus>>_flag>>_attachments>>red>>green>>blue;
		dstream>>strFrom>>strTo>>_subject>>strSentDate>>strReceivedDate>>_scheduling>>_priority>>_parentIndexID>>_size>>_contentType;
		
		_color=QColor(red, green, blue);
		_sentDate=DateClass((const char *)strSentDate);
		_receivedDate=DateClass((const char *)strReceivedDate);
		_from=AddressClass((const char *)strFrom);
		_to=AddressListClass((const char *)strTo.join(", "));
		
		__cached=true;
		
		return true;
	}
	else
	{
		__cached=false;
		
		return VObject::sync();
	}
}

void MailObject::_narrow(const QByteArray &descriptor)
{
	__cached=false;
		
	if(descriptor.size())
	{
		QDataStream stream(descriptor, IO_ReadOnly);
		QString strFrom, strSentDate, strReceivedDate, strReplyTo;
		QStringList strCc, strBcc, strTo;
		Q_UINT8 red, green, blue;

		stream>>strFrom;
		stream>>strTo;
		stream>>_subject;
		stream>>_status;
		stream>>_priority;
		stream>>_contentType;
		stream>>strSentDate;
		stream>>strReceivedDate;
		stream>>_scheduling;
		stream>>_flags;
		stream>>red>>green>>blue;
		stream>>_flag;
		stream>>_inReplyTo;
		stream>>_references;
		stream>>_indexID;
		stream>>_parentIndexID;
		stream>>_relatedIndexIDList;

		stream>>strReplyTo;
		stream>>strCc;
		stream>>strBcc;
		stream>>_messageID;
		stream>>_organization;
		stream>>_uid;
		stream>>_extendedStatus;
		stream>>_contentEncoding;
		stream>>_account;
		stream>>_route;
		stream>>_requestReceipt;
		stream>>_archive;
		stream>>_category;
		stream>>_persistence;
		stream>>_extraData;
		
		stream>>_attachments;
		stream>>_size;

		// build client-specific data structures
		_from=AddressClass((const char *)strFrom);
		_to=AddressListClass((const char *)strTo.join(", "));
		_sentDate=DateClass((const char *)strSentDate);
		_receivedDate=DateClass((const char *)strReceivedDate);
		_color=QColor(red, green, blue);
		_replyTo=AddressClass((const char *)strReplyTo);
		_cc=AddressListClass((const char *)strCc.join(", "));
		_bcc=AddressListClass((const char *)strBcc.join(", "));
	}
	else
	{
		_subject="no data";
	}
}

QByteArray MailObject::_stream()
{
	QByteArray descriptor;
	QDataStream stream(descriptor, IO_WriteOnly);

	stream<<QString(_from.toQCString());
	stream<<QStringList::fromStrList(_to.toQStrList());
	stream<<_subject;
	stream<<_status;
	stream<<_priority;
	stream<<_contentType;
	stream<<QString(_sentDate.toQCString());
	stream<<QString(_receivedDate.toQCString());
	stream<<_scheduling;
	stream<<_flags;
	stream<<(Q_UINT8)_color.red()<<(Q_UINT8)_color.green()<<(Q_UINT8)_color.blue();
	stream<<_flag;
	stream<<_inReplyTo;
	stream<<_references;
	stream<<_indexID;
	stream<<_parentIndexID;
	stream<<_relatedIndexIDList;

	stream<<QString(_replyTo.toQCString());
	stream<<QStringList::fromStrList(_cc.toQStrList());
	stream<<QStringList::fromStrList(_bcc.toQStrList());
	stream<<_messageID;
	stream<<_organization;
	stream<<_uid;
	stream<<_extendedStatus;
	stream<<_contentEncoding;
	stream<<_account;
	stream<<_route;
	stream<<_requestReceipt;
	stream<<_archive;
	stream<<_category;
  stream<<_persistence;
	stream<<_extraData;

	stream<<_attachments;
	stream<<_size;
	
	return descriptor;
}

AddressClass MailObject::from()
{
	return _from;
}

void MailObject::setFrom(const AddressClass &newFrom)
{
	_from=newFrom;
}

AddressListClass MailObject::to()
{
	return _to;
}

void MailObject::setTo(const AddressListClass &newTo)
{
	_to=newTo;
}

QString MailObject::subject()
{
	return _subject;
}

void MailObject::setSubject(const QString &newSubject)
{
	_subject=newSubject;
}

QString MailObject::status()
{
	return _status;
}

void MailObject::setStatus(const QString &newStatus)
{
	_status=newStatus;
}

QString MailObject::priority()
{
	return _priority;
}

void MailObject::setPriority(const QString &newPriority)
{
	_priority=newPriority;
}

DateClass MailObject::sentDate()
{
	return _sentDate;
}

void MailObject::setSentDate(const DateClass &newSentDate)
{
	_sentDate=newSentDate;
}

DateClass MailObject::receivedDate()
{
	return _receivedDate;
}

void MailObject::setReceivedDate(const DateClass &newReceivedDate)
{
	_receivedDate=newReceivedDate;
}

QString MailObject::scheduling()
{
	return _scheduling;
}

void MailObject::setScheduling(const QString &newScheduling)
{
	_scheduling=newScheduling;
}

QStringList MailObject::flags()
{
	return _flags;
}

void MailObject::setFlags(const QStringList &newFlags)
{
	_flags=newFlags;
}

QColor MailObject::color()
{
	return _color;
}

void MailObject::setColor(const QColor &newColor)
{
	_color=newColor;
}

bool MailObject::flag()
{
	return _flag;
}

void MailObject::setFlag(bool newFlag)
{
	_flag=newFlag;
}

QString MailObject::inReplyTo()
{
	return _inReplyTo;
}

void MailObject::setInReplyTo(const QString &newInReplyTo)
{
	_inReplyTo=newInReplyTo;
}

QStringList MailObject::references()
{
	return _references;
}

void MailObject::setReferences(const QStringList &newReferences)
{
	_references=newReferences;
}

QString MailObject::indexID()
{
	return _indexID;
}

void MailObject::setIndexID(const QString &newIndexID)
{
	_indexID=newIndexID;
}

QString MailObject::parentIndexID()
{
	return _parentIndexID;
}

void MailObject::setParentIndexID(const QString &newParentIndexID)
{
	_parentIndexID=newParentIndexID;
}

QStringList MailObject::relatedIndexIDList()
{
	return _relatedIndexIDList;
}

void MailObject::setRelatedIndexIDList(const QString &newRelatedIndexIDList)
{
	_relatedIndexIDList=newRelatedIndexIDList;
}

AddressClass MailObject::replyTo()
{
	return _replyTo;
}

void MailObject::setReplyTo(const AddressClass &newReplyTo)
{
	_replyTo=newReplyTo;
}

AddressListClass MailObject::cc()
{
	return _cc;
}

void MailObject::setCc(const AddressListClass &newCc)
{
	_cc=newCc;
}

AddressListClass MailObject::bcc()
{
	return _bcc;
}

void MailObject::setBcc(AddressListClass &newBcc)
{
	_bcc=newBcc;
}

QString MailObject::messageID()
{
	return _messageID;
}

void MailObject::setMessageID(const QString &newMessageID)
{
	_messageID=newMessageID;
}

QString MailObject::organization()
{
	return _organization;
}

void MailObject::setOrganization(const QString &newOrganization)
{
	_organization=newOrganization;
}

QString MailObject::uid()
{
	return _uid;
}

void MailObject::setUid(const QString &newUid)
{
	_uid=newUid;
}

QStringList MailObject::extendedStatus()
{
	return _extendedStatus;
}

void MailObject::setExtendedStatus(const QStringList &newExtendedStatus)
{
	_extendedStatus=newExtendedStatus;
}

QString MailObject::contentType()
{
	return _contentType;
}

void MailObject::setContentType(const QString &newContentType)
{
	_contentType=newContentType;
}

QString MailObject::contentEncoding()
{
	return _contentEncoding;
}

void MailObject::setContentEncoding(const QString &newContentEncoding)
{
	_contentEncoding=newContentEncoding;
}

QString MailObject::account()
{
	return _account;
}

void MailObject::setAccount(const QString &newAccount)
{
	_account=newAccount;
}

QStringList MailObject::route()
{
	return _route;
}

void MailObject::setRoute(const QStringList &newRoute)
{
	_route=newRoute;
}

bool MailObject::requestReceipt()
{
	return _requestReceipt;
}

void MailObject::setRequestReceipt(bool newRequestReceipt)
{
	_requestReceipt=newRequestReceipt;
}

QString MailObject::archive()
{
	return _archive;
}

void MailObject::setArchive(const QString &newArchive)
{
	_archive=newArchive;
}

QString MailObject::category()
{
	return _category;
}

void MailObject::setCategory(const QString &newCategory)
{
	_category=newCategory;
}

int MailObject::persistence()
{
	return _persistence;
}

void MailObject::setPersistence(int newPersistence)
{
	_persistence=newPersistence;
}

// non-resident data

unsigned long MailObject::size()
{
  return _size;
}

bool MailObject::attachments()
{
  return _attachments;
}

QCString MailObject::message()
{
	return QCString(BrokerInterface::thisInstance()->getSimpleData(path()+"%rfc822message"));
}

QCString MailObject::header()
{
	return QCString(BrokerInterface::thisInstance()->getSimpleData(path()+"%rfc822header"));
}

bool MailObject::hasHTML()
{
	return _narrowBool(BrokerInterface::thisInstance()->getSimpleData(path()+"%hashtml"));
}

bool MailObject::hasText()
{
	return _narrowBool(BrokerInterface::thisInstance()->getSimpleData(path()+"%hastext"));
}

QCString MailObject::text()
{
	QCString textData;
	if(BrokerInterface::thisInstance()->getObjectData(path()+"%text", textData))
		return textData;
	else
		return "";
}

QCString MailObject::html()
{
	QCString htmlData;
	if(BrokerInterface::thisInstance()->getObjectData(path()+"%html", htmlData))
		return htmlData;
	else
		return "";
}

bool MailObject::textPart()
{
	return _narrowBool(BrokerInterface::thisInstance()->getSimpleData(path()+"%textpart"));
}

int MailObject::messageText()
{
	return _narrowInt(BrokerInterface::thisInstance()->getSimpleData(path()+"%messagetext"));
}

bool MailObject::htmlPart()
{
	return _narrowBool(BrokerInterface::thisInstance()->getSimpleData(path()+"%htmlpart"));
}

bool MailObject::isReplied()
{
	return _extendedStatus.grep(QRegExp("^replied:")).count();
}

bool MailObject::isForwarded()
{
	return _extendedStatus.grep(QRegExp("^forwarded:")).count();
}

bool MailObject::setProperty(const QString &property, Any &value)
{
	return false;
}

bool MailObject::getProperty(const QString &property, Any &value)
{
	return false;
}

QueryProcessor::QueryType MailObject::queryType(const QString &)
{
	return QueryProcessor::InvalidQuery;
}

MailObject *MailObjectFactory::_new(QString _path)
{
	return ClientVFS::thisInstance()->template _new<MailObject>(_path);
}

MailObject *MailObjectFactory::_new(QString _path, QByteArray &_data)
{
	return ClientVFS::thisInstance()->template _new<MailObject>(_path, _data);
}



