/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __MagellanComm__
#define __MagellanComm__

// this namespace defines the command codes used in a client-server interaction

namespace MagellanComm
{
	enum ClientCommands
	{
		RcptOk=0,
		UrlIsFolder,
		UrlExists,
		GetParent,
		GetFolder,
		GetChildren,
		GetSubfolders, // not used since we don't make use of server-side hierarchies in such a brutal manner; it will probably be removed or changed when VDXI comes (Virtual Data eXchange Interface)
		GetRelated,
		GetType,       // will probably become outdated since the server storage devices will be moved on the VDXI architecture
		GetSubtype,    // same notice as above
		SetRelated,
		SetParent,
		GetData,
		/** Get the data for many objects.*/
		GetObjectsData,
		/** Get the data for many objects.*/
		GetServerObjectsData,
		/** Get the folder's children data.*/
		GetChildrenData,
		SetData,
		CreateObject,
		CreateFolder,
		CopyUrl,
		MoveUrl,
		RemoveUrl,
		RemoveFolder,
		SendUrl,
		RegetLastError,
		RegisterNotify	
	};
	
	enum ServerCommands
	{
		ObjectCreated=1000,
		ObjectsCreated,
		ObjectDeleted,
		ObjectChanged,
		FolderCreated,
		FolderDeleted,
		FolderPurged,
		HierarchyChanged,
		IOProgress
	};
		
	enum Common
	{
		RMICall=2000
	};
};

#endif



