/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <conversions.h>

int _narrowInt(const QByteArray &d)
{
	int t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

QString _narrowQString(const QByteArray &d)
{
  if(d.isEmpty()) return QString::null;
  
	QString t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

bool _narrowBool(const QByteArray &d)
{
	int t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

QStringList _narrowQStringList(const QByteArray &d)
{
	QStringList t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

QCString _narrowQCString(const QByteArray &d)
{
	QCString t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

QStrList _narrowQStrList(const QByteArray &d)
{
	QStrList t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

QDateTime _narrowQDateTime(const QByteArray &d)
{
	QDateTime t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

QFont _narrowQFont(const QByteArray &d)
{
	QFont t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

QPoint _narrowQPoint(const QByteArray &d)
{
	QPoint t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

QSize _narrowQSize(const QByteArray &d)
{
	QSize t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

Any _narrowAny(const QByteArray &d)
{
	Any t;
	QDataStream s(d, IO_ReadOnly);
	s>>t;
	return t;
}

RMICallData _narrowRMICallData(const QByteArray &d)
{
	RMICallData t;
	QDataStream s(d, IO_ReadOnly);
	s>>t.method>>t.pcount;
	Any a;
	for(int i=0;i<t.pcount;i++) { s>>a; t.param.append(a); }
	return t;
}

QByteArray _stream(const QString &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(const QCString &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(const QStringList &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(const QStrList &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(const QDateTime &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(const QFont &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(const QPoint &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(const QSize &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(int t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(bool t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<(int)t;
	return d;
}

QByteArray _stream(const Any &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}

QByteArray _stream(const RMICallData &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t.method<<t.pcount;
	for(int i=0;i<t.pcount;i++) s<<t.param[i];
	return d;
}

QByteArray _stream(const QMap<QString, QByteArray> &t)
{
	QByteArray d;
	QDataStream s(d, IO_WriteOnly);
	s<<t;
	return d;
}
