/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qscrollview.h>
#include <qlist.h>
#include <qpixmap.h>
#include <qpainter.h>

// Class used for displaying a vertical, centered, equally-spaced collection of buttons.
// Used as widget for "New" and "Preferences"
/**
 *
 *	ChangeLog:
 *		10 Feb 2000: Added persistence feature for buttons (set by default)
 *								 Added pressed(int) signal which is emitted when a new button is clicked.
 *							Its parameter is the index of the button in the widgets list.
 *								 Added setPersistence(bool) method to set up the persistence...
 *			(Laur)
 *
 */

class EButton;

class ECollection : public QWidget
{
	Q_OBJECT
	protected:
			void resizeEvent(QResizeEvent *e);
	public:
			ECollection(QWidget *parent=0, const char *name=0);
			~ECollection();
			void addButton(const QPixmap &p, QObject *receiver=0, const char *slot=0);
      void addButton(EButton *b, QObject *receiver=0, const char *slot=0);
			void setSpacing(int s);
			void setPersistence(bool p);
  protected slots:
      void scroll_up();
      void scroll_down();
			void button_clicked(int);
	signals:
			void newButtonClicked(int index);
	private:
			QPixmap oldPixmap;
			int oldIndex;
			bool persistence;
			QList<EButton> childList;
			int spacing;
      QScrollView *sview;
      EButton *button_up;
      EButton *button_down;
      QPalette p;
};









