/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/** Changed by Eugen C. <eug@thekompany.com> - 05 July 2001 */

#ifndef __NetProtocol__
#define __NetProtocol__

#include <string>
#include <netsocket.h>
#include <netgroup.h>

#define MAX_READ_BUFFER_SIZE       99999999
#define MAX_MESSAGE_DIGITS_NR           10 // 2^32

class NetProtocol : public NetGroup
{
	public:
		enum Mode { Read_Default=0, Read_One_Line,
		            POP3_Read_Line, POP3_Read_MultiLine,  /** POP3 read modes.*/
		            SMTP_Read_Line,                       /** SMTP read mode.*/
		            IMAP4_Read_Line                       /** IMAP4 read modes.*/
		          };
	
		NetProtocol();
		NetProtocol(const char *);
		virtual ~NetProtocol();
		/** Make the connection with "host" to "port".*/
		bool connect(string host, int port);
		/** Disconnect the client.*/
		void disconnect();
		/** Check the connection state.*/
		bool isConnected();
		/** Get the connection socket.*/
		NetSocket& socket();
		/** Set the reading mode.*/
		void setMode(Mode);
		/** Check if the client gets the end of response.*/
		virtual bool checkEndOfResponse(const string&) const;
		
		/** Write a string.*/
		NetProtocol& operator>>(string&);
		/** Write a number.*/
		NetProtocol& operator<<(const string&);
		/** Read a max number of bytes.*/
		NetProtocol& operator<<(int);
		
	protected:
		/** The connection socket.*/
		NetSocket netsock;
		/** The reading mode.*/
		Mode mode;
};

#endif


