/***************************************************************************
                uidjar.cpp  -  the UID jar interface class 
                             -------------------
    begin                : Wed Mar 14 19:02:00 EET 2001
    copyright            : (C) 2001 by theKompany (www.thekompany.com>
    author               : Eugen Constantinescu
    email                : eug@thekompany.com
 ***************************************************************************/

#include <uidjar.h>
#include <stdio.h>

UIDJar::UIDJar()
{
}
        
UIDJar::~UIDJar()
{
}
       
void UIDJar::loadLists()
{	
  // load the received UID
  ifstream rcvFile(rcvFileName.c_str());
  
  printf("\nLoad the UID from file:%s\n", rcvFileName.c_str());
  fflush(stdout);
  
  string uidString;
  UIDINFO uidData;
    
  if( rcvFile )
  {
    while( rcvFile )
    {
      // init
      uidString="";
      uidData.info="";
      uidData.rcvTime=0;
      
      rcvFile >> uidString;
      rcvFile >> uidData.info;
			rcvFile >> uidData.rcvTime;
			// insert the new UID in the map
			if( uidString.size() )
        rcvList.insert(UIDValuePair(uidString, uidData));
    }
    rcvFile.close();
  }

  printf("\n********* UIDJAR ********* = %u\n", rcvList.size());
  fflush(stdout);
    
  // load the deleted UID
  ifstream delFile(delFileName.c_str());
  if( delFile )
  {
    while( delFile )
    {
      // init
      uidString="";
      uidData.info="";
      uidData.rcvTime=0;
      
      delFile >> uidString;
      delFile >> uidData.info;
			delFile >> uidData.rcvTime;
			// A new UID is ready to be deleted :)
			if( uidString.size() )
        trashList.insert(UIDValuePair(uidString, uidData));
    }
    delFile.close();
  }
}

void UIDJar::saveLists()
{
//  printf("\n********* UIDJAR SAVE ********* = %u\n", rcvList.size());
//  fflush(stdout);
    
  ofstream rcvFile(rcvFileName.c_str());
  if( rcvFile )
  {
		for(UIDMap::iterator it=rcvList.begin(); it!=rcvList.end(); ++it)
		{
      rcvFile << (*it).first;
			rcvFile << " ";
      rcvFile << (*it).second.info;
			rcvFile << " ";
			rcvFile << (*it).second.rcvTime;
			rcvFile << "\n";
		}
    rcvFile.close();
  }
  		
  ofstream delFile(delFileName.c_str());
  if( delFile )
  {
		for(UIDMap::iterator it=trashList.begin(); it!=trashList.end(); ++it)
		{
      delFile << (*it).first;
			delFile << " ";
      delFile << (*it).second.info;
			delFile << " ";
			delFile << (*it).second.rcvTime;
			delFile << "\n";
		}
    delFile.close();
  }
}

