/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __AttributeMarshall__
#define __AttributeMarshall__

#include <qstring.h>
#include <qdatetime.h>
#include <qdatastream.h>

struct _Attribute
{
	virtual ~_Attribute();
	
	QString owner, device, dtype, rtype, flags; // dtype="device type", rtype="retrieval type"
	int size, active;
	QDateTime lmodified;
	
	virtual QString type();
	
	friend QDataStream& operator<<(QDataStream &, _Attribute &);
	friend QDataStream& operator>>(QDataStream &, _Attribute &);
};

struct _MailAttribute : public _Attribute
{
	int uniblockOffset, uniblockLength, descriptorOffset, descriptorLength;
	int partCount, multipartOnly;
		
	QString type();
		
	friend QDataStream& operator<<(QDataStream &, _MailAttribute &);
	friend QDataStream& operator>>(QDataStream &, _MailAttribute &);
};

struct _BlockObjectAttribute : public _Attribute
{
	int offset;		
	
	QString type();

	friend QDataStream& operator<<(QDataStream &, _BlockObjectAttribute &);
	friend QDataStream& operator>>(QDataStream &, _BlockObjectAttribute &);
};

struct _FolderAttribute : public _Attribute
{
	int items, recent, folders;

	QString type();
		
	friend QDataStream& operator<<(QDataStream &, _FolderAttribute &);
	friend QDataStream& operator>>(QDataStream &, _FolderAttribute &);
};

struct _PartAttribute : public _Attribute
{
	QString mimetype, name, cid, encoding, charset, mtype, embeddedPath;
	int partOffset, partLength;

	QString type();
		
	friend QDataStream& operator<<(QDataStream &, _PartAttribute &);
	friend QDataStream& operator>>(QDataStream &, _PartAttribute &);
};

// streaming conversions

QByteArray _stream(_Attribute &);
QByteArray _stream(_MailAttribute &);
QByteArray _stream(_FolderAttribute &);
QByteArray _stream(_BlockObjectAttribute &);
QByteArray _stream(_PartAttribute &);

_Attribute _narrowAttribute(const QByteArray &data);
_MailAttribute _narrowMailAttribute(const QByteArray &data);
_FolderAttribute _narrowFolderAttribute(const QByteArray &data);
_BlockObjectAttribute _narrowIObjectAttribute(const QByteArray &data);
_PartAttribute _narrowPartAttribute(const QByteArray &data);

#endif
