/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <orb.h>
#include <magellan.h>
#include <mailclasses.h>
#include <indexclass.h>
#include <transactionserver.h>
#include <attributemarshall.h>
#include <conversions.h>

QString ObjectRequestBroker::move(QString url, QString dest_folder_url)
{
	// debug
	printf("orb: move called [%s->%s]\n", (const char *)url, (const char *)dest_folder_url);
	
  if(!exists(url))
  {
		// debug
		printf("orb: cannot move a non-existent object\n");
		
    err="Cannot move a non-existent object";
    return QString::null;
  }
  if(!isFolder(dest_folder_url))
  {
		// debug
		printf("orb: cannot move into a non-existent folder\n");
		
    err="Cannot move into a non-existent destination folder";
    return QString::null;
  }

  int stype=subtype(url);
  int dtype=subtype(dest_folder_url);

	// temporary, until we get part mimetypes
  if(stype!=dtype)
  {
		// debug
		printf("orb: the object type and destination folder must match\n");
		
    err="The object type and destination folder type must match";
    return QString::null;
  }
	
  if(stype==Magellan::Message)
  {
		// debug
		printf("orb: trying to move a mail message...\n");
		
		MailFolder *dfolder=mailfolderReference(dest_folder_url);
    IndexClass *idx=indexReference(url);

    if(!dfolder)
    {
      printf("Warning: URLManager::mailfolderReference() returned null when a valid pointer was expected, bailing out\n");
      err="Internal error in URLManager::mailfolderReference()";
      return QString::null;
    }
		
    if(!idx)
    {
      printf("Warning: URLManager::indexReference() returned null when a valid pointer was expected, bailing out\n");
      err="Internal error in URLManager::indexReference()";
      return QString::null;
    }
		
		if(idx->isLocked())
		{
			printf("Warning: message is locked, cannot move\n");
			err="Message was locked by the mail spooler, cannot move";
			return QString::null;
		}

    // move the message
    err="Internal error in MailDispatcher::copyMessage()";
    IndexClass *tidx=dfolder->moveMessage(idx);
    if(!tidx)
    {
			// debug
//			printf("orb: moveMessage returned null when a valid pointer was expected, bailing out\n");
			
      return QString::null;
    }

    QString tobj=tidx->getID();
    if(dest_folder_url[dest_folder_url.length()-1]!='/')
      tobj.prepend("/");
    tobj.prepend(dest_folder_url);

		// debug
		printf("orb: done [new object %s]\n", (const char *)tobj);
		
    return tobj;
  }

  // this is a vCard object, use the new architecture

	// debug
	printf("orb: trying to move datacollection object...\n");
	
  QString tobj=reparentObject(url, dest_folder_url);

  if(tobj.isEmpty())
  {
		// debug
		printf("orb: a null object string was received, bailing out\n");
		
    err="Internal error in CollectionManager::reparentObject()";
    return QString::null;
  }

	ServerNotifier::thisInstance()->objectDeleted(url);
	ServerNotifier::thisInstance()->objectCreated(tobj);
	
	// debug
	printf("orb: done [new object %s]\n", (const char *)tobj);
	
  return tobj;
}

