/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

/*
This class defines the basic structure of a data handler widget/data colletion.
Inherit DataHandlerImpl (this is an abstact class) and implement the appropriate methods to have syncronized clipboard and DnD behaviour.
*/

#ifndef __DataHandler__
#define __DataHandler__

#include <qlist.h>
#include <datawidget.h>

class QDragEnterEvent;
class QDropEvent;
class QWidget;

class DataHandler
{
  public:
    DataHandler();
    virtual ~DataHandler();
  
		virtual void registerWidget(DataWidget *);
		virtual void unregisterWidget(DataWidget *);
		
    // redraw children in normal mode, cut failed
    virtual void discardCut(); // called after a "cut" on the current object is cancelled

    // connection with the clipboard wrapper is handled via this method; internal use only
    virtual void clipboardOperationCompleted(int id);
  
		virtual DataWidget::ViewState state(DataWidget *);
    virtual void changeState(DataWidget *, DataWidget::ViewState s);
		
    // reimplement this if you need to "gray out" items, while calling the original method too
    virtual void grayOutSelection();
		virtual int cutSelection()=0;
 		virtual int copySelection()=0;
		virtual void deleteSelection()=0;
		
		virtual void newObject()=0;
		
		virtual void openSelection()=0;
		virtual void sendSelection()=0;
		virtual void printSelection()=0;
		virtual void saveSelection()=0;
		
		virtual void moveSelectionTo()=0;
		virtual void copySelectionTo()=0;
		
		virtual void editProperties()=0;
		
		// make sure you call this before pasting data
		virtual bool canPaste();
		virtual void paste()=0;

		// DnD support
		virtual void dragStart(QWidget *dragSource) = 0;
		virtual void dragEnter(QDragEnterEvent* event) = 0;
		virtual void dragDrop(QDropEvent* event) = 0;
		
		virtual void selectAll();
		virtual void unselectAll();
		virtual void select(DataWidget *);
		virtual void select(QList<DataWidget> &);
		virtual void addToSelection(DataWidget *);
		virtual void addToSelection(QList<DataWidget> &);
		virtual void removeFromSelection(DataWidget *);
		virtual void removeFromSelection(QList<DataWidget> &wList);
		
		virtual bool isSelectionEmpty();
		virtual bool isSelectionSingle();
		virtual bool isSelectionMultiple();
		
		virtual QList<DataWidget> getSelection();
  protected:
    int lastID;
		QList<DataWidget> childViews;
};

#endif
