/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <addressfieldedit.h>
#include <addresslineedit.h>
#include <qpushbutton.h>
#include <addresslistclass.h>
#include <addaddressesdialog.h>
#include <qlayout.h>
#include <composerwidget.h>

AddressFieldEdit::AddressFieldEdit(QWidget *parent, const char *name):QWidget(parent, name)
{
	layout=new QHBoxLayout(this, 3);
	button=new QPushButton(this);
	edit=new AddressLineEdit(this);
	layout->addWidget(button);
	layout->addWidget(edit);
	
	button->setFixedSize(75, 25);
	edit->setFixedHeight(25);
		
	button->show();
	edit->show();
	layout->activate();
	
	connect(button, SIGNAL(clicked()), this, SLOT(editAddresses()));
	connect(edit, SIGNAL(textChanged(const QString &)), this, SLOT(ackTextChanged(const QString &)));
}

AddressFieldEdit::~AddressFieldEdit()
{
}

bool AddressFieldEdit::isEmpty()
{
	return edit->text().isEmpty();
}

AddressListClass *AddressFieldEdit::addressList()
{
	_addressList=edit->updateAddresses();
	return &_addressList;
}

void AddressFieldEdit::setAddressList(AddressListClass addr)
{
	_addressList=addr;
	QStringList list;
	for(int i=0;i<_addressList.count();i++)
	{
		list.append((const char *)(QCString(addr[i])));
	}
	edit->lineEdit()->setText(list.join(","));
}

void AddressFieldEdit::setLabel(QString txt)
{
	label=txt;
	button->setText(label);
}

void AddressFieldEdit::editAddresses()
{
	AddressListClass to=*(((ComposerWidget *)parentWidget())->toAddresses());
	AddressListClass cc=*(((ComposerWidget *)parentWidget())->ccAddresses());
	AddressListClass bcc=*(((ComposerWidget *)parentWidget())->bccAddresses());
	AddAddressesDialog::newDialog(&to, &cc, &bcc, this);
	((ComposerWidget *)parentWidget())->setToAddresses(to);
	((ComposerWidget *)parentWidget())->setCcAddresses(cc);
	((ComposerWidget *)parentWidget())->setBccAddresses(bcc);
}

void AddressFieldEdit::ackTextChanged(const QString &)
{
	emit addressChanged();
}
