/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qfiledialog.h>
#include <qfile.h>
#include <qcstring.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>
#include <kmimetype.h>
#include <composerattpane.h>
#include <attachmentpanewidget.h>
#include <brokeriface.h>
#include <partobj.h>
#include <clientvfs.h>
#include <composerwindow.h>
#include <mailobj.h>

ComposerAttachmentPane::ComposerAttachmentPane(ComposerWindow *composer, QWidget *parent, const char *name, WFlags f):AttachmentPane(parent, name, f), _composer(composer)
{
  setChildWidth(100);
  setChildHeight(70);
  viewport()->setBackgroundColor(QColor("white"));
  makeGlobalPopup();
	makeChildPopup();
}

ComposerAttachmentPane::~ComposerAttachmentPane()
{
}

void ComposerAttachmentPane::makeGlobalPopup()
{
  mainPopup=new QPopupMenu();
  
  mainPopup->insertItem("Add attachment", this, SLOT(slotNewObject()));
  mainPopup->insertItem("Remove all", this, SLOT(removeAll()));
}

void ComposerAttachmentPane::makeChildPopup()
{
	childPopup=new QPopupMenu();
	
  childPopup->insertItem("Add attachment", this, SLOT(slotNewObject()));
	childPopup->insertItem("Remove attachment", this, SLOT(slotDeleteSelection()));
	childPopup->insertSeparator();
  childPopup->insertItem("Remove all", this, SLOT(removeAll()));
	childPopup->insertSeparator();
	childPopup->insertItem("Properties", this, SLOT(slotEditProperties()));
}

void ComposerAttachmentPane::newObject()
{
	if(_address.isEmpty() || !BrokerInterface::thisInstance()->exists(_address))
	{
		QMessageBox::warning(_composer, "Aethera: Cannot add attachment", "Attachments cannot be added to this object because\n"
				"it doesn't exist on the server. Please restart the application and try again.",
				QMessageBox::Ok, QMessageBox::NoButton);
	}
	else
	{
		QString fileName=QFileDialog::getOpenFileName(QString::null, QString::null, _composer);

		if(!fileName.isEmpty())
		{
			if(QFile::exists(fileName) && QFileInfo(fileName).isReadable())
			{
				QString partPath=BrokerInterface::thisInstance()->createObject(_address);
				if(partPath.isEmpty())
				{
					QMessageBox::warning(_composer, "Aethera: Cannot add attachment", QString("Could not create attachment object.\n")+
							"The server reply was:\n" +
							BrokerInterface::thisInstance()->lastError(), QMessageBox::Ok, QMessageBox::NoButton);
				}
				else
				{
					PartObject *item=(PartObject *)ClientVFS::thisInstance()->_fact_ref(partPath, "part");
					if(!item)
					{
						QMessageBox::warning(_composer, "Aethera: Cannot add attachment", "Could not retrieve attachment object.\n"
								"Please restart the application.", QMessageBox::Ok, QMessageBox::NoButton);
					}
					else
					{
						QFile attachmentFile(fileName);

						if(attachmentFile.open(IO_ReadOnly))
						{
							int fileSize=attachmentFile.size();
							char *buf=new char[fileSize];
							attachmentFile.readBlock(buf, fileSize);

							QByteArray data;
							data.setRawData(buf, fileSize);

							item->setFilename(QFileInfo(fileName).fileName());
							item->setPartType("attachment");
							item->setMimeType(KMimeType::findByURL(QString("file:/"+fileName), 0, true)->name());
							item->setEncoding("base64");

							// debug
							// printf("composerattachmentpane: [new object] saving attachment properties...\n");

							bool savePartInfo=item->save();

							// debug
							// printf("composerattachmentpane: [new object] save properties result: %s\n", savePartInfo?"true":"false");

							// debug
							// printf("composerattachmentpane: [new object] saving attachment data...\n");

							bool setData=item->setData(data);

							// debug
							// printf("composerattachmentpane: [new object] save data result: %s\n", setData?"true":"false");

							if(!setData || !savePartInfo)
							{
								QMessageBox::warning(_composer, "Aethera: Cannot add attachment", QString("Could not save attachment object.\n")+
										"Reason given by server: \n" + BrokerInterface::thisInstance()->regetLastError(),
										QMessageBox::Ok, QMessageBox::NoButton);
								delete item;
								BrokerInterface::thisInstance()->remove(partPath);
							}
							else
							{
								AttachmentPaneWidget *view = new AttachmentPaneWidget(item, this);
//								item->addView(view);
								addChild(view);
								show();
								view->show();
							}
						}
						else
						{
							QMessageBox::warning(_composer, "Aethera: Cannot add attachment", "Could not open file for reading.\n"
									"Please check that it exists and try again.", QMessageBox::Ok, QMessageBox::NoButton);
							delete item;
							BrokerInterface::thisInstance()->remove(partPath);
						}
					}
				}
			}
			else
			{
				QMessageBox::warning(_composer, "Aethera: Cannot add attachment", "Could not open file for reading.\n"
									"Please check the file permissions and try again.", QMessageBox::Ok, QMessageBox::NoButton);
			}
		}
	}
}

void ComposerAttachmentPane::deleteSelection()
{
	QList<DataWidget> selection=getSelection();
	
	for (unsigned int i=0; i < selection.count(); i++)
		BrokerInterface::thisInstance()->remove(((AttachmentPaneWidget *)selection.at(i))->path());
	
	MailObject *obj=(MailObject *)ClientVFS::thisInstance()->_fact_ref(_address, "mail");
	if(obj->attachments()==false) hide();
}

void ComposerAttachmentPane::removeAll()
{
	for (unsigned int i = 0; i < childViews.count(); i++)
		BrokerInterface::thisInstance()->remove(((AttachmentPaneWidget *)childViews.at(i))->path());
	hide();
}

void ComposerAttachmentPane::slotDeleteSelection()
{
	deleteSelection();
}

void ComposerAttachmentPane::slotNewObject()
{
	newObject();
}

void ComposerAttachmentPane::slotEditProperties()
{
	editProperties();
}
