/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * $Id: mailwindow.cpp,v 1.4 2001/05/19 10:53:18 alex Exp $
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qlayout.h>
#include <qtooltip.h>

#include <kmenubar.h>

#include <mailwindow.h>
#include <epopupbutton.h>
#include <ebutton.h>
#include <pixmaps.h>
#include <videotoolbox.h>

#define STATUS_BG_COLOR 191, 209, 232

MailWindow::MailWindow(IndexClass *idx, const char *name):KTMainWindow(name)
{
	QPopupMenu *file=new QPopupMenu();
	QPopupMenu *edit=new QPopupMenu();
	QPopupMenu *message=new QPopupMenu();
	QPopupMenu *help=new QPopupMenu();
	menuBar()->insertItem("&File", file);
	menuBar()->insertItem("&Edit", edit);
	menuBar()->insertItem("&Message", message);
	menuBar()->insertSeparator();
	menuBar()->insertItem("&Help", help);
  
	menuBar()->show();
	statusBar()->message("");

	EButton *newmail_button=new EButton(toolBar(), "new mail button");
	newmail_button->setNormalPixmap(BarIcon("new-mail-normal"));
	newmail_button->setFocusPixmap(BarIcon("new-mail-focus"));
	newmail_button->setClickedPixmap(BarIcon("new-mail-focus"));
	newmail_button->setText(" New mail ");
	newmail_button->setToolBarStyle(20);
	QToolTip::add(newmail_button, "New mail message");

	toolBar()->insertWidget(1, 80, newmail_button);
	toolBar()->insertWidget(2, 3, toolSeparator(toolBar()));

	EButton *deletemail_button=new EButton(QPixmap(delete_xpm), toolBar());
	deletemail_button->setToolBarStyle(20);
	toolBar()->insertWidget(3, 35, deletemail_button);

	toolBar()->insertWidget(4, 3, toolSeparator(toolBar()));

	EButton *printmail_button=new EButton(QPixmap(print_xpm), toolBar());
	printmail_button->setToolBarStyle(20);
	toolBar()->insertWidget(5, 35, printmail_button);

	toolBar()->insertWidget(6, 3, toolSeparator(toolBar()));

	EButton *getmail_button=new EButton(toolBar(), "getmail button");
	getmail_button->setNormalPixmap(BarIcon("getmail-normal"));
	getmail_button->setFocusPixmap(BarIcon("getmail-focus"));
	getmail_button->setClickedPixmap(BarIcon("getmail-focus"));
	getmail_button->setText("Send and Receive ");
	getmail_button->setToolBarStyle(20);
	toolBar()->insertWidget(7, 40, getmail_button);
	toolBar()->insertWidget(8, 3, toolSeparator(toolBar()));
	//toolBar()->insertWidget(3, 3, toolSeparator(toolBar()));
	EButton *forward_button=new EButton(toolBar(), "forward button");
	forward_button->setNormalPixmap(BarIcon("forward-normal"));
	forward_button->setFocusPixmap(BarIcon("forward-focus"));
	forward_button->setClickedPixmap(BarIcon("forward-focus"));
	forward_button->setText("Forward ");
	forward_button->setToolBarStyle(20);
	toolBar()->insertWidget(9, 40, forward_button);
	EButton *reply_button=new EButton(toolBar(), "reply button");
	reply_button->setNormalPixmap(BarIcon("reply-normal"));
	reply_button->setFocusPixmap(BarIcon("reply-focus"));
	reply_button->setClickedPixmap(BarIcon("reply-focus"));
	reply_button->setText("Reply ");
	reply_button->setToolBarStyle(20);
	toolBar()->insertWidget(20, 40, reply_button);
	EButton *replyall_button=new EButton(toolBar(), "replyall button");
	replyall_button->setNormalPixmap(BarIcon("replyall-normal"));
	replyall_button->setFocusPixmap(BarIcon("replyall-focus"));
	replyall_button->setClickedPixmap(BarIcon("replyall-focus"));
	replyall_button->setText("Reply All ");
	replyall_button->setToolBarStyle(20);
	toolBar()->insertWidget(11, 40, replyall_button);
	toolBar()->insertWidget(12, 3, toolSeparator(toolBar()));

	EPopupButton *arrowdown_popup=new EPopupButton(toolBar());
	arrowdown_popup->button()->setNormalPixmap(BarIcon("arrow-down-normal"));
	arrowdown_popup->button()->setFocusPixmap(BarIcon("arrow-down-focus"));
	arrowdown_popup->button()->setClickedPixmap(BarIcon("arrow-down-focus"));
	arrowdown_popup->button()->setToolBarStyle(20);
	toolBar()->insertWidget(13, 48, arrowdown_popup);

	EPopupButton *arrowup_popup=new EPopupButton(toolBar());
	EButton *arrowup_button;
	arrowup_button = new EButton(arrowup_popup, "arrowup button");
	arrowup_popup->button()->setNormalPixmap(BarIcon("arrow-up-normal"));
	arrowup_popup->button()->setFocusPixmap(BarIcon("arrow-up-focus"));
	arrowup_popup->button()->setClickedPixmap(BarIcon("arrow-up-focus"));
	arrowup_popup->button()->setToolBarStyle(20);
 	toolBar()->insertWidget(14, 48, arrowup_popup);

	toolBar()->insertWidget(15, 3, toolSeparator(toolBar()));
	EButton *helpmail_button=new EButton(toolBar());
	helpmail_button->setNormalPixmap(BarIcon("help-normal"));
	helpmail_button->setFocusPixmap(BarIcon("help-focus"));
	helpmail_button->setClickedPixmap(BarIcon("help-focus"));
	helpmail_button->setToolBarStyle(20);
	toolBar()->insertWidget(16, 35, helpmail_button);

	//if(idx)
	//    setCaption(idx->Subject);
	setIcon(BarIcon("mailwindow"));
	mainw=new QWidget(this);
	l=new QVBoxLayout(mainw);
	view=new MailView(mainw, false);
	index=idx;
	statusview=new StatusView(mainw);
	l->addWidget(statusview);
	l->addWidget(view);
	view->show();
	statusview->show();
	l->activate();

	mainw->show();
	setView(mainw);
}

MailWindow::~MailWindow()
{
	delete(statusview);
	delete(view);
	delete(l);
	delete(mainw);
}

ToolBarSeparator* MailWindow::toolSeparator(QWidget *parent, const char *name)
{
	return new ToolBarSeparator(parent, name);
}

StatusView::StatusView(QWidget *parent, const char *name):QWidget(parent, name)
{
	setBackgroundColor(QColor(STATUS_BG_COLOR));
	pix=new QLabel(this);
	pix->setFixedSize(25, 25);
	pix->setPixmap(BarIcon("info"));
	pix->setBackgroundColor(QColor(STATUS_BG_COLOR));
	status=new QLabel("No additional information is available about this message.", this);
	status->setAutoResize(true);
	text=new QLabel("Click here to find all related messages.", this);
	text->setAutoResize(true);
	setFixedHeight(32);
	pix->move(2, 2);
	status->move(30, 2);
	text->move(30, 14);
	status->setBackgroundColor(QColor(STATUS_BG_COLOR));
	text->setBackgroundColor(QColor(STATUS_BG_COLOR));
	status->setFont(QPxFont("helvetica", 10));
	text->setFont(QPxFont("helvetica", 10));
	hline=new QFrame(this);
	hline->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	hline->setGeometry(0, 30, 2000, 3);
  
	pix->installEventFilter(this);
	text->installEventFilter(this);
	status->installEventFilter(this);
	hline->installEventFilter(this);
}

void StatusView::setText(QString &txt)
{
	status->setText(txt);
}

StatusView::~StatusView()
{
	delete(pix);
	delete(status);
	delete(text);
}

bool StatusView::eventFilter(QObject *, QEvent *e)
{
	if (e->type()==QEvent::MouseButtonPress || (e->type()==QEvent::MouseButtonDblClick)) {
		emit(clicked());
	}
	return false;
}
