/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qtextstream.h>
#include <qframe.h>

#include <kapp.h>
#include <kiconloader.h>

#include <mailer.h>
#include <clipboard.h>
#include <pixmaps.h>
#include <videotoolbox.h>
#include <notewindow.h>
#include <notewidget.h>
#include <textfitter.h>

NoteWindow::NoteWindow(NoteObject *item):QFrame(0, 0, WDestructiveClose), TemplateView(item)
{
//	KWin::setType(winId(), NET::Override);
		
	item->addView(this);
	item->setOnDisplay(true);
	setFrameStyle(QFrame::Box | QFrame::Plain);
	QColor newcolor;
	QString color=item->color();
	if(color=="yellow") newcolor=QColor(255, 255, 140);
	if(color=="red")    newcolor=QColor(255, 206, 206);
	if(color=="green")  newcolor=QColor(187, 255, 173);
	if(color=="blue")   newcolor=QColor(214, 245, 255);
	
	QColorGroup light(QColor("black"), newcolor, QColor("black"), QColor("black"),
			QColor("black"), QColor("black"), newcolor);
	QColorGroup dark(QColor(255, 255, 140), QColor(128, 0, 0), QColor("black"), QColor("black"),
			QColor("black"), QColor(255, 255, 140), QColor(128, 0, 0));
	
	setBackgroundColor(newcolor);
			
	label=new QLabel(this);
  label->setText("");
  label->setAlignment( AlignHCenter);
  label->installEventFilter(this);
	label->setPalette(QPalette(dark, dark, dark));
	label->setGeometry(18, 2, width()-36, 14);
	label->setFont(QPxFont("helvetica", 12, QFont::Bold));
			
	cl_button=new EButton(BarIcon("x"), this);
	cl_button->setNormalFrameStyle(QFrame::NoFrame);
	cl_button->setFocusFrameStyle(QFrame::Box|QFrame::Plain);
	cl_button->setClickedFrameStyle(QFrame::Box|QFrame::Plain);
	cl_button->setContentMargin(0);
	cl_button->setGeometry(width()-16, 2, 14, 14);
	cl_button->installEventFilter(this);

  edit_box = new NoteEdit(this);
  edit_box->setGeometry(2, 18, width()-4 , height()-39);
  edit_box->installEventFilter(this);
  edit_box->setFocus();
  edit_box->setFrameStyle(QFrame::NoFrame);	
	edit_box->setPalette(QPalette(light, light, light));
	edit_box->setWordWrap(QMultiLineEdit::WidgetWidth);
	edit_box->setText(item->text());
	
	hline=new QFrame(this);
	hline->setFrameStyle(QFrame::HLine|QFrame::Plain);
	hline->setLineWidth(1);
	hline->setMidLineWidth(0);
	hline->setGeometry(2, height()-20, width()-2, 1);
	hline->installEventFilter(this);
	
	date_line=new QLabel(this);
	QString s;
	QDateTime d=item->time();
	s.sprintf("%02d %s %04d  %02d:%02d", d.date().day(), (const char *)d.date().monthName(d.date().month()),
			d.date().year(), d.time().hour(), d.time().minute());
	date_line->setText(s);
	date_line->setGeometry(2, height()-16, width()-20, 14);
	date_line->setPalette(QPalette(light, light, light));
	date_line->installEventFilter(this);
	
	resize_pix=new QLabel(this);
	resize_pix->setPalette(QPalette(light, light, light));
	resize_pix->setBackgroundMode(PaletteBackground);
	resize_pix->setPixmap(BarIcon("resize"));
	resize_pix->setGeometry(width()-16, height()-16, 14, 14);
	resize_pix->installEventFilter(this);
	
	icon=new QLabel(this);
	icon->setPixmap(BarIcon("notes"));
	icon->setGeometry(2, 2, 14, 14);
	icon->setPalette(QPalette(light, light, light));
	icon->setBackgroundMode(PaletteBackground);
	icon->installEventFilter(this);
				
	setMinimumSize(100, 100);
	
	resize(item->size());
	
	connect(cl_button, SIGNAL(clicked()), this, SLOT(close()));
	connect(edit_box, SIGNAL(textChanged()), this, SLOT(setTitle()));
	connect(edit_box, SIGNAL(textChanged()), this, SLOT(updateText()));
	
	popupMenu=new QPopupMenu();
	colorPopup=new QPopupMenu();
	popupMenu->insertItem(QPixmap(cut_xpm),    "Cut",   this, SLOT(cut()),      0, 1);
	popupMenu->insertItem(QPixmap(copy_xpm),   "Copy",  this, SLOT(copyText()), 0, 2);
	popupMenu->insertItem(QPixmap(paste_xpm),  "Paste", this, SLOT(paste()),    0, 3);
	popupMenu->insertItem(QPixmap(delete_xpm), "Delete");
	popupMenu->insertItem("Select all", this, SLOT(selectAllText()), 0, 4);
	popupMenu->insertSeparator();
	colorPopup->insertItem("Yellow", this, SLOT(setYellow()));
	colorPopup->insertItem("Red",    this, SLOT(setRed()));
	colorPopup->insertItem("Blue",   this, SLOT(setBlue()));
	colorPopup->insertItem("Green",  this, SLOT(setGreen()));
	popupMenu->insertItem("Change color to..", colorPopup);
	popupMenu->insertSeparator();
	popupMenu->insertItem("Print", this, SLOT(printNote()), 0, 6);
	popupMenu->insertSeparator();
	popupMenu->insertItem("Send to ...");
	popupMenu->insertSeparator();
	popupMenu->insertItem("Change font ...");
	popupMenu->setItemEnabled(1, false);
	popupMenu->setItemEnabled(2, false);
	popupMenu->setItemEnabled(3, false);
	setTitle();
}

NoteWindow::~NoteWindow()
{
	((NoteObject *)getVItem())->setOnDisplay(false);
	((NoteObject *)getVItem())->removeView(this);
	printf("Note Widget: view [%d]\n", ((NoteObject *)getVItem())->altViews().count());
	((NoteObject *)getVItem())->save();
	delete(label);
	delete(edit_box);
	delete(cl_button);
	delete(hline);
	delete(date_line);
	delete(resize_pix);
	delete(icon);
}

void NoteWindow::resizeEvent(QResizeEvent *e)
{
	label->setGeometry(18, 2, width()-36, 14);
	cl_button->setGeometry(width()-16, 2, 14, 14);
  edit_box->setGeometry(2, 18, width()-4 , height()-39);	
	hline->setGeometry(2, height()-20, width()-2, 1);
	date_line->setGeometry(2, height()-16, width()-20, 14);
	resize_pix->setGeometry(width()-16, height()-16, 14, 14);
	icon->setGeometry(2, 2, 14, 14);
	setTitle();
	
	NoteObject *obj=(NoteObject *)getVItem();
	if(obj)
	{
		obj->setSize(e->size());
		obj->save();
	}
}

bool NoteWindow::eventFilter(QObject *o, QEvent *ev)
{
	static QPoint tmp_point;
		
  QMouseEvent *e=(QMouseEvent *)ev;
	
	if(o==edit_box && ev->type()==QEvent::MouseButtonPress && e->button()==RightButton)
	{
		showPopup();
		return true;
	}

	if(o==resize_pix)
	{
    if(ev->type()==QEvent::MouseButtonRelease)
		{
      if(e->button()==LeftButton)
			{
        dragging=false;
        resize_pix->releaseMouse();
				QPoint delta=QCursor::pos()-mapToGlobal(QPoint(0,0));
				resize(delta.x(), delta.y());
        raise();
      }
      if(e->button()==MidButton)
        lower();
      return true;
    }
    if(ev->type()==QEvent::MouseButtonPress && e->button() == LeftButton)
		{
      pointerOffset=e->pos();
			pointerOffset.setX(pointerOffset.x()+18);
			pointerOffset.setY(pointerOffset.y()+2);
      resize_pix->grabMouse(sizeFDiagCursor);
      return true;
    }
	}
  if(o==label)
	{
    if(ev->type()==QEvent::MouseButtonRelease)
		{
      if(e->button()==LeftButton)
			{
        dragging=false;
        label->releaseMouse();
        raise();
      }
      if(e->button()==MidButton)
        lower();
      return true;
    }
    if(ev->type()==QEvent::MouseButtonPress && e->button() == LeftButton)
		{
      pointerOffset=e->pos();
			pointerOffset.setX(pointerOffset.x()+18);
			pointerOffset.setY(pointerOffset.y()+2);
      label->grabMouse(sizeAllCursor);
      return true;
    }
    if(ev->type()==QEvent::MouseMove && label==mouseGrabber())
			{
        if(dragging) 
				{
						NoteObject *obj=(NoteObject *)getVItem();
						if(obj)
						{
							obj->setPosition(QCursor::pos()-pointerOffset);
							obj->save();
						}
            move(QCursor::pos()-pointerOffset);
        }
				else 
				{
        	dragging=(
          	(e->pos().x()-pointerOffset.x())
          	*
          	(e->pos().x()-pointerOffset.x())
          	+
          	(e->pos().y()-pointerOffset.y())
            	*
          	(e->pos().y()-pointerOffset.y())
          	>= 9);
      }
      return true;
    }
    if(ev->type()==QEvent::MouseMove)
      return true;
  }
	
  tmp_point = QCursor::pos();
	
  return QWidget::eventFilter(o, ev);
}

void NoteWindow::setTitle()
{
	QString t, src;
	unsigned int i=0;

	if (!edit_box->text().isEmpty())
		t=edit_box->text();

	if (t.length() > 0)
	{
		while (i<t.length()) 
			if (t[i]==0x0a||t[i]==0x0d||t[i]==0x20)
				i++;
			else
				break;
		while (i<t.length()) 
			if (t[i]!=0x0a&&t[i]!=0x0d)
				src+=t[i++];
			else
				break;
	}
	TextFitter tf;
	label->setText(tf.fitText(src,label->width()-10,label->font()));
}

void NoteWindow::cut()
{
	if(edit_box->hasMarkedText())
	{
		edit_box->cut();
	}
}

void NoteWindow::copy()
{
	if(edit_box->hasMarkedText())
	{
		edit_box->copy();
	}
}

void NoteWindow::paste()
{
}

void NoteWindow::setYellow()
{
	setNoteColor("yellow");
}

void NoteWindow::setBlue()
{
	setNoteColor("blue");
}

void NoteWindow::setRed()
{
	setNoteColor("red");
}

void NoteWindow::setGreen()
{
	setNoteColor("green");
}

void NoteWindow::printNote()
{
}

void NoteWindow::selectAllText()
{
	edit_box->selectAll();
}

void NoteWindow::showPopup()
{
	if(edit_box->hasMarkedText()==TRUE)
	{
		popupMenu->setItemEnabled(1, TRUE);
		popupMenu->setItemEnabled(2, TRUE);
	}
	else
	{
		popupMenu->setItemEnabled(1, FALSE);
		popupMenu->setItemEnabled(2, FALSE);
	}	
// 	if(PrivateClipboard->isEmpty()||PrivateClipboard->canConvert(text_entry)==FALSE)
// 	{
// 		 popupMenu->setItemEnabled(3, FALSE);
// 	}
// 	else
// 	{
// 		if(PrivateClipboard->canConvert(text_entry)==TRUE)
// 		{
// 			popupMenu->setItemEnabled(3, TRUE);
// 		}
// 	}
	popupMenu->updateItem(1);
	popupMenu->updateItem(2);
	popupMenu->updateItem(2);
	popupMenu->popup(QCursor::pos());
}

void NoteWindow::setNoteColor(const QString &c)
{
	NoteObject *item=(NoteObject *)getVItem();
	if(c==item->color()) return;
	
	QColor newcolor;
	if(c=="yellow") newcolor=QColor(255, 255, 140);
	if(c=="red") newcolor=QColor(255, 206, 206);
	if(c=="green") newcolor=QColor(187, 255, 173);
	if(c=="blue") newcolor=QColor(214, 245, 255);
	
	QColorGroup light(QColor("black"), newcolor, QColor("black"), QColor("black"),
			QColor("black"), QColor("black"), newcolor);
	
	setBackgroundColor(newcolor);
	
	edit_box->setPalette(QPalette(light, light, light));
	date_line->setPalette(QPalette(light, light, light));
	icon->setPalette(QPalette(light, light, light));
	icon->setBackgroundMode(PaletteBackground);
	resize_pix->setPalette(QPalette(light, light, light));
	resize_pix->setBackgroundMode(PaletteBackground);	
	
	repaint();
	
	item->setColor(c);
	item->save();
	item->updateViews(this);
}

void NoteWindow::updateText()
{
	NoteObject *item=(NoteObject *)getVItem();
	item->setText(edit_box->text());
	item->save();
	item->updateViews(this);
}

void NoteWindow::update()
{
	NoteObject *item=(NoteObject *)getVItem();
	
	QColor newcolor;
	QString color=item->color();
	
	if(color=="yellow") newcolor=QColor(255, 255, 140);
	if(color=="red")    newcolor=QColor(255, 206, 206);
	if(color=="green")  newcolor=QColor(187, 255, 173);
	if(color=="blue")   newcolor=QColor(214, 245, 255);
	
	QColorGroup light(QColor("black"), newcolor, QColor("black"), QColor("black"),
			QColor("black"), QColor("black"), newcolor);
	
	setBackgroundColor(newcolor);
						
	edit_box->setPalette(QPalette(light, light, light));
	edit_box->setText(item->text());
		
	QString s;
	QDateTime d=item->time();
	s.sprintf("%02d %s %04d  %02d:%02d", d.date().day(), (const char *)d.date().monthName(d.date().month()),
			d.date().year(), d.time().hour(), d.time().minute());
	date_line->setText(s);
	
	resize_pix->setPalette(QPalette(light, light, light));
	
	icon->setPalette(QPalette(light, light, light));
	
	resize(item->size());
	
	setTitle();
}
