#ifndef FILTER_H
#define FILTER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define ACTIONS_COUNT 5

#include <qstringlist.h>

#include <kconfig.h>

class IndexClass;
class MessageDevice;
class MessageClass;

class FilterRule
{
friend class Filter;
public:
  FilterRule(QString &field, QString &function, QString &context );
  ~FilterRule();

  bool match( MessageDevice* );

  bool match( MessageClass* );

protected:
  bool matchList( QStringList );

  QString m_field;
  QString m_function;
  QString m_context;
};


class FilterAction
{
friend class Filter;
public:
  FilterAction( QString &action, QString &param );
  ~FilterAction();

  bool apply( IndexClass*, MessageDevice*, bool useForwardActions = true );

  QString messageFolder();

private:
  QString m_action;
  QString m_param;

  // "execute" action stuff

};



class Filter
{
public:
  Filter( KConfig *config, QString group, int id );
  ~Filter();

  bool match( MessageDevice*  );

  /** apply filter actions to message,
   *  dosn't check if message much to filter, use @match for this.
   */
  void apply( IndexClass*, MessageDevice*, bool useForwardActions );

  /** return folder for message ( if "forward" action present )
   *  or QString::NULL
   */
  QString messageFolder( MessageClass* );

  void readConfig( KConfig *config, QString group, int id );

protected:

  bool match( MessageClass*  );

  FilterRule *rule1, *rule2;
  QString ruleLogic; // "ignore", "and", "or" , "unless"

  FilterAction *actions[ ACTIONS_COUNT ];

};


#endif





