/*
 * client.hh 
 * Copyright (C) 2002 Frank Hale
 * frankhale@yahoo.com
 * http://sapphire.sourceforge.net/
 *
 * Updated: 13 Jan 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 
#ifndef _CLIENT_HH_
#define _CLIENT_HH_

#include "aewm.hh"

class Client
{
private: /* Private Member Variables */

    	Display 	*dpy;
	Window 		root;
	XSizeHints	*size;
    	Colormap	cmap;
	int 		screen;

	// Screen resolution
	int 	xres;
	int	yres;

    	char	*name;	// Name used to display in titlebar
	//char 	*icon_name;

	Window	window;	// actual client window
	Window  frame;	// parent window which we reparent the client to
	Window  title;	// window which holds title
	Window  trans;	// window id for which this client is transient for

	WindowMenu *window_menu; // menu which lets us change the clients
	    		 	 // virtual desktop.

	// The position and dimensions of the client window
	int  x;	
	int  y;
	int  width;
	int  height;

	// The old position and dimensions of the client, used 
	// in the maximize function.
	int  old_x; 
	int  old_y;
	int  old_width;
	int  old_height;   

    	bool has_focus;
   	bool has_title;
	bool has_border;

    	bool is_shaded;
    	bool is_iconified;
	bool is_maximized;
	bool is_maximized_vertical;
	bool is_maximized_horizontal;
	bool is_sticky;
	bool is_always_on_top;

	bool wire_move; // Do we wanna move clients by wire or opaque?

	#ifdef SHAPE
    		bool has_been_shaped;
	#endif

	Strut *client_strut;		
	bool has_strut;
	bool has_extended_net_name;
	bool skip_taskbar;
	bool skip_pager;

    	int belongsToDesktop;
    	int last_button1_time;
    
    	int ignore_unmap;
 	
	// For window title placement
	XCharStruct overall;
	int direction;
	int ascent;
	int descent;
	int text_width;
	int text_justify;
	int justify_style;
	
	// Used in client move
	int pointer_x, pointer_y;
	int old_cx, old_cy;

public: /* Public Member Functions */

	Client(Display *d, Window new_client, LinkedList<Client> *l);
	~Client();
	
	void make_new_client(Window);
	void remove_client();

	Client *find_client(Window, int);

	bool wantsFullScreen() { return (x==0 && y==0 && width>=xres && height>=yres) ? true : false; }
	
	char* getClientName() const { return name; }
	char* getClientIconName() const { return name; } // for now just return name
	
	Window getFrameWindow() 	const { return frame; 		}
	Window getAppWindow() 		const { return window; 		}
	Window getTitleWindow()		const { return title;		}
	Window getTransientWindow() 	const { return trans; 		}

	bool hasWindowDecorations() 	const { return has_title; }
	bool hasFocus()			const { return has_focus; }
	
	int belongsToWhichDesktop() 	const { return belongsToDesktop;}
	bool isAlwaysOnTop()		const { return is_always_on_top;}
	bool isIconified() 		const { return is_iconified; 	}
	bool isSticky() 		const { return is_sticky; 	}
	char*  getAppName() 		const { return name; 		}

	void hide();
	void unhide();
	void iconify();
	void shade();
	void maximize();

	void set_desktop(int desk);

	// Event handlers below - Used by WindowManager
	void handle_button_event(XButtonEvent *);
	void handle_configure_request(XConfigureRequestEvent *);
	void handle_map_request(XMapRequestEvent *);
	void handle_unmap_event(XUnmapEvent *);
	void handle_destroy_event(XDestroyWindowEvent *);
	void handle_client_message(XClientMessageEvent *);
	void handle_property_change(XPropertyEvent *);
	void handle_enter_event(XCrossingEvent *);
	void handle_leave_event(XCrossingEvent *e);
	void handle_colormap_change(XColormapEvent *);
	void handle_expose_event(XExposeEvent *);
	void handle_focus_in_event(XFocusChangeEvent *);
	void handle_focus_out_event(XFocusChangeEvent *);
	void handle_motion_notify_event(XMotionEvent *);

	#ifdef SHAPE
		void handle_shape_change(XShapeEvent *);
	#endif

	void raise();
	void lower();

	void set_focus(bool focus);

private: /* Private Member Functions */

	void initialize(Display *d);
	
	void update_net_wm_states();
	
	void getXClientName();
	
	// Not currently using Icon name for any purpose.
	//void getXIconName();
	
	void drag();
	void redraw();
	void sweep();
	void recalc_sweep(int, int, int, int);
	void draw_outline();
	int  get_incsize(int *, int *, int);
	void init_position();
	void fixupPositionBasedOnStruts(Strut* temp_strut);
	void reparent();
	int  theight();
	void set_wm_state(int);
	long get_wm_state();
	void send_config();
	void gravitate(int);
	void move();
	void resize();
	void send_wm_delete();
	int  send_xmessage(Window, Atom, long, long);
	
	MwmHints* get_mwm_hints(Window);

	#ifdef SHAPE
		void set_shape();
	#endif
};

#endif
