
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>


#include "patchlevel.h"

#include "afio.h"


struct extnode { char *ext; struct extnode *next; };


struct extnode de1={ ".Z", NULL };
struct extnode de2={ ".z", &de1 };
struct extnode de3={ ".gz", &de2 };
struct extnode de4={ ".bz2", &de3 };
 
struct extnode de5={ ".arc", &de4 };
struct extnode de6={ ".zip", &de5 };
struct extnode de7={ ".rar", &de6 };
struct extnode de8={ ".lzh", &de7 };
struct extnode de9={ ".lha", &de8 };
struct extnode de10={ ".uc2", &de9 };
struct extnode de11={ ".tpz", &de10 };
struct extnode de12={ ".taz", &de11 };
struct extnode de13={ ".tgz", &de12 };
struct extnode de14={ ".rpm", &de13 };
struct extnode de15={ ".zoo", &de14 };
struct extnode de16={ ".deb", &de15 };

struct extnode de17={ ".gif", &de16 };
struct extnode de18={ ".jpeg", &de17 };
struct extnode de19={ ".jpg", &de18 };
struct extnode de20={ ".tif", &de19 };
struct extnode de21={ ".tiff", &de20 };
struct extnode de22={ ".png", &de21 };

struct extnode defaultext={ ".tzg", &de22 };



struct extnode *compexts=&defaultext;

/* Read file extensions of files that are not to be compressed
 * from compextsfile.
 * Extenstions in the file are seperated by whitespace.
 * a # begins a comment that lasts till the end of the line.
 */
int readcompexts(char *compextsfile)
{
 FILE *infile;
 char ex[81];
 int c;
 struct extnode *tmp;

 infile=fopen(compextsfile,"r");
 if(infile==0) return 0;

 compexts=NULL;

 while(fscanf(infile,"%80s",ex)!=EOF)
   {
     if(ex[0]=='#')
       { /* throw away comment. */
        do{
           c=fgetc(infile);
           if(c==EOF)  { fclose(infile); return 1; }
          }while(c!='\n');
        continue;
       }

     tmp=(struct extnode *)malloc(sizeof(struct extnode));
     if(tmp==NULL) break;
     if((tmp->ext=strdup(ex))==NULL) break;
     tmp->next=compexts;
     compexts=tmp;
   }

 fclose(infile);
 return 1;
}

int matchcompext(char *s)
{
 struct extnode *p;
 int sl;

 p=compexts;
 sl=strlen(s);

 while(p!=NULL)
   {
    if(sl >= strlen(p->ext))
            if(strcmp(s+sl-strlen(p->ext),p->ext)==0) return 1;
     p=p->next;
   }

 return 0;
}



