// ---------------------------------------------------------------------------
// - t_argument.cpp                                                          -
// - afnix engine - argument class tester module                             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Argument.hpp"

int main (int, char**) {
  using namespace afnix;

  // create an argument
  String hello = "hello";
  Argument arg (hello.toquark (), 0);
  if (arg.repr () != "Argument") return 1;

  // check for members
  if (arg.toliteral () != hello) return 1;
  if (arg.tostring  () != hello) return 1;

  // check the const flag
  if (arg.getconst () == true)  return 1;
  arg.setconst (true);
  if (arg.getconst () == false) return 1;

  // success
  return 0;
}
