// ---------------------------------------------------------------------------
// - cthr.hpp                                                                -
// - standard system library - c thread function definitions                 -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_CTHR_HPP
#define  AFNIX_CTHR_HPP

#ifndef  AFNIX_CCNF_HPP
#include "ccnf.hpp"
#endif

namespace afnix {

  /// the supported type of threads
  enum t_thrmode {
    THR_NORMAL, 
    THR_DAEMON
  };
  /// the function that runs the thread
  typedef void* (*t_thrfunc) (void*);
  /// the destructor for the thread result
  typedef void (*t_thrdtor) (void*);
  
  /// create a new thread of control
  /// @param mode the thread mode to start
  /// @param func the function to start
  /// @param args the function arguments
  /// @param dtor the thread destructor
  void* c_thrstart (t_thrmode mode, t_thrfunc func, void* args, 
		    t_thrdtor dtor);

  /// @return true if the thread system is initialized
  bool c_thralive (void);

  /// @return the unique thread id
  void* c_thrself (void);

  /// @return true if the thread id equal the self one
  bool c_threqual (void* thr);

  /// @return true if the thread is the master one
  bool c_thrmaster (void);

  /// set the main thread object
  void c_thrsetmain (void* object);

  /// get the thread object
  void* c_thrgetobj (void);

  /// @return the thread result
  void* c_thrgetres (void* thr);

  /// wait for a thread to terminate
  /// @param thr the thread handle
  void c_thrwait (void* thr);

  /// exit a thread
  void c_threxit (void);

  /// destroy eventually a thread record
  /// @param thr the thread to destroy
  void c_thrdestroy (void* thr);

  /// wait for all normal threads to finish
  void c_thrwaitall (void);

  /// create a new mutex in a unlock state
  void* c_mtxcreate (void);

  /// destroy the mutex argument
  void c_mtxdestroy (void* mtx);

  /// lock a mutex and return true on success
  /// @param mtx the mutex to lock
  bool c_mtxlock (void* mtx);

  /// unlock a mutex and return true on success
  /// @param mtx the mutex to unlock
  bool c_mtxunlock (void* mtx);

  /// @return true if a mutex is locked
  bool c_mtxtry (void* mtx);

  /// create a new condition variable
  void* c_tcvcreate (void);

  /// lock on a condition variable
  /// @param tcv the condition variable
  void c_tcvlock (void* tcv);

  /// unlock on a condition variable
  /// @param tcv the condition variable
  void c_tcvunlock (void* tcv);

  /// wait on a condition variable
  /// @param tcv the condition variable
  /// @param mtx the control mutex
  void c_tcvwait (void* tcv, void* mtx);

  /// signal on a condition variable
  /// @param tcv the condition variable
  void c_tcvsignal (void* tcv);

  /// broadcast on a condition variable
  /// @param tcv the condition variable
  void c_tcvbdcast (void* tcv);

  /// destroy a condition variable
  /// @param tcv the condition variable
  void c_tcvdestroy (void* tcv);
}

#endif
