// ---------------------------------------------------------------------------
// - t_buffer.cpp                                                            -
// - standard object library - buffer class tester                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Ascii.hpp"
#include "Buffer.hpp"
#include "Exception.hpp"

int main (int, char**) {
  using namespace afnix;

  // try to create a buffer with negative size
  try {
    Buffer* wrong = new Buffer ((long) -1);
    delete wrong;
  }
  catch (const Exception& e) {
    // we should catch this exception
  } catch (...) {
    // if we are here, it is an error
    return 1;
  }

  // create a default buffer with 0 size
  Buffer* buffer = new Buffer ((long) 0);

  // check for length equal to 0
  if (buffer->length () != 0) return 1;

  // add the magic string into it
  const char* magic = "hello world";
  long        size  = Ascii::strlen (magic);
  for (long i = 0; i < size; i++) buffer->add (magic[i]);

  // check for the length again
  if (buffer->length () != size) return 1;
  // check the result string
  String value = buffer->tostring ();
  if (value != magic) return 1;

  // reset the buffer and check string and size
  buffer->reset ();
  if (buffer->length () != 0)   return 1;

  // add in full mode
  buffer->add (magic);
  // check for the length again
  if (buffer->length () != size) return 1;
  // check the result string
  value = buffer->tostring ();
  if (value != magic) return 1;

  // finally - no failure
  delete buffer;
  return 0;
}
