// ---------------------------------------------------------------------------
// - t_date.cpp                                                              -
// - standard object library - date class tester                             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Date.hpp"
#include "Exception.hpp"

int main (int, char**) {
  using namespace afnix;

  // check the origin (0000-00-00 is a saturday)
  Date date (0LL);
  if (date.getyear () != 0)     return 1;
  if (date.getymon () != 1)     return 1;
  if (date.getmday () != 1)     return 1;
  if (date.getwday () != 6)     return 1;
  if (date.mapwday () != "Sat") return 1;
  if (date.mapymon () != "Jan") return 1;
  // check the string format
  if (date.todate  ()     != "0000-01-01") return 1;
  if (date.totime  (true) != "00:00:00")   return 1;
  if (date.toiso   (true) != "0000-01-01T00:00:00Z") return 1;
  if (date.format  (true) != "Sat Jan 1 00:00:00 0") return 1;

  // check my birthday (1964-11-20 is a friday)
  date.setdate (1964,11,20);
  if (date.getyear () != 1964)  return 1;
  if (date.getymon () != 11)    return 1;
  if (date.getmday () != 20)    return 1;
  if (date.getwday () != 5)     return 1;
  if (date.mapwday () != "Fri") return 1;
  if (date.mapymon () != "Nov") return 1;
  // check the string format
  if (date.todate  ()     != "1964-11-20") return 1;
  if (date.totime  (true) != "00:00:00")   return 1;
  if (date.toiso   (true) != "1964-11-20T00:00:00Z")     return 1;
  if (date.format  (true) != "Fri Nov 20 00:00:00 1964") return 1;

  // check the epoch (1970-1-1 is a thursday)
  date.setdate (1970,1,1);
  if (date.gettime () != 62167219200LL) return 1;
  if (date.getyear () != 1970)  return 1;
  if (date.getyday () != 1)     return 1;
  if (date.getymon () != 1)     return 1;
  if (date.getmday () != 1)     return 1;
  if (date.getwday () != 4)     return 1;
  if (date.mapwday () != "Thu") return 1;
  if (date.mapymon () != "Jan") return 1;
  // check the string format
  if (date.todate  ()     != "1970-01-01") return 1;
  if (date.totime  (true) != "00:00:00")   return 1;
  if (date.toiso   (true) != "1970-01-01T00:00:00Z")    return 1;
  if (date.format  (true) != "Thu Jan 1 00:00:00 1970") return 1;

  // check the millenium bug!! (1999-12-31 is a friday)
  date.setdate (1999,12,31);
  if (date.getyear () != 1999)  return 1;
  if (date.getyday () != 365)   return 1;
  if (date.getymon () != 12)    return 1;
  if (date.getmday () != 31)    return 1;
  if (date.getwday () != 5)     return 1;
  if (date.mapwday () != "Fri") return 1;
  if (date.mapymon () != "Dec") return 1;
  // check the string format
  if (date.todate  ()     != "1999-12-31") return 1;
  if (date.totime  (true) != "00:00:00")   return 1;
  if (date.toiso   (true) != "1999-12-31T00:00:00Z")     return 1;
  if (date.format  (true) != "Fri Dec 31 00:00:00 1999") return 1;

  // check the millenium!! (2000-12-31 is a sunday and is a leap year)
  date.setdate (2000,12,31);
  if (date.getyear () != 2000 ) return 1;
  if (date.getyday () != 366)   return 1;
  if (date.getymon () != 12)    return 1;
  if (date.getmday () != 31)    return 1;
  if (date.getwday () != 0)     return 1;
  if (date.mapwday () != "Sun") return 1;
  if (date.mapymon () != "Dec") return 1;
  // check the string format
  if (date.todate  ()     != "2000-12-31") return 1;
  if (date.totime  (true) != "00:00:00")   return 1;
  if (date.toiso   (true) != "2000-12-31T00:00:00Z")     return 1;
  if (date.format  (true) != "Sun Dec 31 00:00:00 2000") return 1;

  // check the last negative day
  date.setdate (-1,12,31);
  if (date.getyear () != -1)    return 1;
  if (date.getyday () != 365)   return 1;
  if (date.getymon () != 12)    return 1;
  if (date.getmday () != 31)    return 1;
  if (date.getwday () != 5)     return 1;
  if (date.mapwday () != "Fri") return 1;
  if (date.mapymon () != "Dec") return 1;
  
  // check the date in reverse
  date.setdate ("2000-12-31T23:59:00Z");
  if (date.getyear () != 2000)  return 1;
  if (date.getymon () != 12)    return 1;
  if (date.getmday () != 31)    return 1;
  if (date.gethour (true) != 23)    return 1;
  if (date.getmins (true) != 59)    return 1;
  if (date.getsecs (true) != 0)     return 1;
  // success
  return 0;
}
