.\" t
.\" @(#)Cascade.1  02/07/00
.TH Cascade 1.8 "Feb 7 2000" Cascade
.UC
.SH NAME
\fBCascade\fP \- the AfterStep window cascading module

.SH SYNOPSIS
\fBCascade\fP [\-f \fIconfig_file\fP] [\-v | \--version] [\-h | \--help]
[\-a] [\-desk] [\-flatx] [\-flaty] [\-incx \fIarg\fP] [\-incy \fIarg\fP] 
[\-m] [\-noraise] [\-nostretch] [\-r] [\-resize] [\-s] [\-t] [\-u] 
[x y [width height]]

.sp
Although \fBCascade\fP can be run from the command line, it is normally 
spawned by afterstep in the \fIautoexec\fP file, in the following manner:
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/Cascade"
	Module "Animate" Cascade -resize 10 2 80 70
	MiniPixmap "mini-as.xpm"
.fi

To stop the \fBCascade\fP module, a menu item can be used:
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/Cascade_Stop"
	KillModuleByName "Stop Cascade" Cascade
	MiniPixmap "mini-as.xpm"
.fi

.SH DESCRIPTION
The \fBCascade\fP module attempts to cascade windows on the current screen
subject to certain constraints.  Layering is performed so consecutive
windows will have their window titles visible underneath the previous.

.SH OPTIONS
.IP "\-f \fIconfig_file\fP"
Use \fIconfig_file\fP instead of the default configuration file.

.IP "\-h | \--help"
Print a usage message and exit successfully.

.IP "\-v | \--version"
Print version information and exit successfully.

.IP "\-a"
Causes \fIall\fP window styles to be affected, even ones with the
WindowListSkip style.

.IP "\-desk"
Causes all windows on the desk to be cascaded instead of the current
screen only.

.IP "\-flatx"
Inhibits border width increment.

.IP "\-flaty"
Inhibits border height increment.

.IP "\-incx \fIarg\fP"
Specifies a horizontal increment which is successively added to
cascaded windows.  \fIarg\fP is a percentage of screen width, or pixel
value if a \fIp\fP is suffixed.  Default is zero.

.IP "\-incy \fIarg\fP"
Specifies a vertical increment which is successively added to cascaded
windows.  \fIarg\fP is a percentage of screen height, or pixel value
if a \fIp\fP is suffixed.  Default is zero.

.IP "\-m"
Causes maximized windows to also be affected (implied by \-all).

.IP "\-noraise"
Inhibits window raising, leaving the depth ordering intact.

.IP "\-nostretch"
Inhibits window expansion when using the \-resize option.  Windows
will only shrink to fit the maximal width and height (if given).

.IP "\-r"
Reverses the window sequence.

.IP "\-resize"
Forces all windows to resize to the constrained width and height (if
given).

.IP "\-s"
Causes sticky windows to also be affected (implied by \-all).

.IP "\-t"
Causes transient windows to also be affected (implied by \-all).

.IP "\-u"
Causes untitled windows to also be affected (implied by \-all).

.SH INVOCATION
\fBCascade\fP can be invoked from binding the action "Module Cascade
\fIoptions\fP" to a key-stroke in the \fIfeel\fP, or from a menu item as
shown in the Synopsis section above.

The \fBCascade\fP module can also be called multiple times with
different options. This way multiple Cascading programs can be used, and
is unlike other modules which require a symlink to run multiple times.

.SH CONFIGURATION OPTIONS
Command-line arguments passed to \fBCascade\fP are described in the 
\fIOPTIONS\fP section, above.

Up to four numbers can be placed on the command line that are not
switches.  The first pair specify an x and y offset to start the first
window (default is 0, 0).  The second pair specify a maximal width and
height for the layered windows.  If an affected window exceeds either
this width or height, it is resized to the maximal width or height.
If each number is suffixed with the letter p, then it is taken to be a
pixel value, otherwise it is interpreted as a screen percentage.
Specifying zero for any parameter is equivalent to not specifying it.

.SH EXAMPLE
As an example case, one could call Cascade with the following arguments:

\fBCascade \-resize 10 2 80 70\fP

This invocation will cascade windows starting 10 by 2 percent into and
down the screen.  Windows will be constrained to 80 by 70 percent of
the screen dimensions.  Since the \fIresize\fP is also specified,
windows will be resized to the given constrained width and height.

.SH BUGS
It is probably not a good idea to delete windows while windows are
being cascaded.

.SH AUTHOR
Andrew Veliath
.nf
David Mihm <dmihm@swbell.net> [Man page]

.SH SEE ALSO
.BR afterstep (1)
