#include "CalendarEvent.h"

@implementation CalendarEvent

+ (CalendarEvent *) calendarEventWithName:(NSString *)name
							 calendarUser:(CalendarUser *)owner
							calendarGroup:(CalendarGroup *)group
								startDate:(NSDate *)startDate
								 stopDate:(NSDate *)stopDate
							summaryString:(NSString *)summary
{
	return AUTORELEASE([[self alloc] initWithName:name
									 calendarUser:owner
									calendarGroup:group
										startDate:startDate
										 stopDate:stopDate
									summaryString:summary]);
}

- (id) initWithName:(NSString *)name
	   calendarUser:(CalendarUser *)owner
	  calendarGroup:(CalendarGroup *)group
		  startDate:(NSDate *)startDate
		   stopDate:(NSDate *)stopDate
	  summaryString:(NSString *)summary
{
	CalendarEvent *oldEv;

	[super init];

	if (owner == nil || __owner != nil || group == nil || [group name] == nil)
	{
		return nil;
	}
	__owner = owner;

	oldEv = [owner calendarEventWithName:name];

	if (oldEv != nil)
	{
		[oldEv setStartDate:startDate
				setStopDate:stopDate
		   setSummaryString:summary];

		AUTORELEASE(self);
		return oldEv;
	}

	ASSIGN(_name, name);
	
	[self setCalendarGroup:group];
	/*
	__group = group;
	[__group setCalendarEvent:self];
	*/

	[self setStartDate:startDate
		   setStopDate:stopDate
	  setSummaryString:summary];

	return self;
}

- (CalendarDomain *) calendarDomain
{
	return [__owner calendarDomain];
}

- (void) setCalendarGroup:(CalendarGroup *)group
{
	id oldgroup;

	if (group == __group)
	{
		return;
	}

	oldgroup = __group;

	group = [__owner calendarGroupWithName:[group name]];

	__group = group;

	[group setCalendarEvent:self];

	[oldgroup removeCalendarEvent:self];

	__group = group;

}

- (void) setStartDate:(NSDate *)startDate
			 stopDate:(NSDate *)stopDate
		summaryString:(NSString *)summary
{
	[self setStartDate:startDate];
	[self setStopDate:stopDate];
	[self setSummaryString:summary];
}

- (id <CalendarUser>) owner
{
	return __owner;
}

- (id <CalendarGroup>) calendarGroup
{
	return __group;
}

- (NSString *) description
{
	return [[NSArray arrayWithObjects:_name, [self calendarDomain], __owner, __group, _startDate, _stopDate, _summary, nil] description];
}

- (void) dealloc
{
	RELEASE(_name);
	RELEASE(_startDate);
	RELEASE(_stopDate);
	RELEASE(_summary);
	[super dealloc];
}

- (NSString *) name
{
	return _name;
}

- (NSString *) summaryString
{
	return _summary;
}

- (void) setSummaryString:(NSString *)string
{
	if (string == nil)
	{
		string = @"";
	}
	ASSIGN(_summary, string);
}

- (NSDate *) startDate
{
	return _startDate;
}

- (NSDate *) stopDate
{
	return _stopDate;
}

- (void) setStartDate:(NSDate *)date
{
	if (date == nil)
	{
		date = [NSDate date];
	}
	ASSIGN(_startDate, date);
}

- (void) setStopDate:(NSDate *)date
{
	if (date == nil)
	{
		date = [NSDate date];
	}
	ASSIGN(_stopDate, date);
}

@end

@implementation CalendarEventManager

- (id) initWithCalendarEvent:(CalendarEvent *)event
		manageByCalendarUser:(CalendarUser *)manager
{
	if (_event || _manager)
	{
		return self;
	}
	ASSIGN(_event, event);
	ASSIGN(_manager, manager);

	return self;
}

- (void) dealloc
{
	RELEASE(_event);
	RELEASE(_manager);
	[super dealloc];
}

- (NSString *) name
{
	if (_manager == [_event owner] || [_manager isRoot])
	{
		return [NSString stringWithString:[_event name]];
	}
	return nil;
}

- (CalendarGroup *) calendarGroup
{
	if (_manager == [_event owner] || [_manager isRoot])
	{
		return AUTORELEASE([[CalendarGroupManager alloc]
				initWithCalendarGroup:[_event calendarGroup]
				 manageByCalendarUser:_manager]);
	}
	return nil;
}

- (NSString *) summaryString
{
	if (_manager == [_event owner] || [_manager isRoot])
	{
		NSLog(@"shoud return %@",[_event summaryString]);
		return AUTORELEASE([[_event summaryString] copy]);
	}
	return nil;
}

- (void) setCalendarGroup:(id <CalendarGroup>)group
{
	if ([_manager canModifyCalendarOwner:[_event group]] &&
		[_manager canAppendCalendarOwner:[[_event owner] calendarGroupWithName:[group name]]])
	{
		RETAIN(self);

	}
}

- (void) setSummaryString:(NSString *)string
{
	if (_manager == [_event owner] || [_manager isRoot])
	{
		[_event setSummaryString:[NSString stringWithString:string]];
	}
	return nil;
}

- (NSDate *) startDate
{
	if (_manager == [_event owner] || [_manager isRoot])
	{
		return AUTORELEASE([[_event startDate] copy]);
	}
	return [NSDate date];
}

- (NSDate *) stopDate
{
	if (_manager == [_event owner] || [_manager isRoot])
	{
		return AUTORELEASE([[_event stopDate] copy]);
	}
	return [NSDate date];
}

- (void) setStartDate:(NSDate *)date
{
	if (_manager == [_event owner] || [_manager isRoot])
	{
		[_event setStartDate:[NSDate dateWithTimeIntervalSinceReferenceDate:[date timeIntervalSinceReferenceDate]]];
	}
}

- (void) setStopDate:(NSDate *)date
{
	if (_manager == [_event owner] || [_manager isRoot])
	{
		[_event setStopDate:[NSDate dateWithTimeIntervalSinceReferenceDate:[date timeIntervalSinceReferenceDate]]];
	}
}


@end
