#include "CalendarEventCell.h"
#include <math.h>
#include "CalendarEventView.h"

@implementation CalendarEventCell

#define CEV_BASELINESIZE 3
#define CEV_TXTBORDER 3

#define CEC_STEPSECONDS ([__owner numberOfMinutesInStep] * 60)
#define CEC_VIEWSECONDS (CEC_STEPSECONDS * [__owner numberOfStepsInUnit] * [__owner numberOfUnits])
#define CEC_UNITHEIGHT ([__owner numberOfStepsInUnit] * [__owner stepHeight])


- (id) initWithOwner:(CalendarEventView *)owner
			   model:(CalendarEventModel *)model
{
	__owner = owner;
	__model = model;

	[super initWithFrame:NSZeroRect];


	[__model addObserver:self];

	ASSIGN(_scrollView, [[NSClipView alloc] initWithFrame:NSZeroRect]);

	ASSIGN(_textView, [[NSTextView alloc] initWithFrame:NSZeroRect]);
	[_textView setEditable:NO];
	[_textView setMinSize: NSMakeSize (0, 0)];
	[_textView setMaxSize: NSMakeSize (1E7, 1E7)];
	[_textView setVerticallyResizable:YES];

	_isSelected = _isEdited = NO;

	[_textView setDrawsBackground:NO];
	/*
	[_textView setBackgroundColor:[NSColor redColor]];
	*/
	[_textView setString:[__model stringValue]];
	[_textView setDelegate: self];

	[self addSubview:_scrollView];

	[_scrollView setDocumentView:_textView];


	return self;
}

- (void) calendarEventModel:(id)model
	   didUpdateStringValue:(NSString *)string
{
}

- (void) textViewDidChangeSelection:(NSNotification *)aNotification
{
	[__model setStringValue:[_textView string]];
}

- (id) model
{
	return __model;
}

- (void) dealloc
{
	[__owner calendarEventCellWillBeFreed:self];
//	NSLog(@"free %@",self);

	RELEASE(_delegate);
	RELEASE(_str);
	RELEASE(_textView);
	RELEASE(_scrollView);
	[super dealloc];
}


#define CEC_TEXTMARGIN 6
- (void) _frameChanged
{
	NSRect b = [self bounds];
	float stepHeight = [__owner stepHeight];

	float minus_height = 0;

	if (NSMaxY(_frame) > NSHeight([_super_view bounds]))
	{
		minus_height = NSMaxY(_frame) - NSHeight([_super_view bounds]);
	}

	b.size.height -= [_str size].height + stepHeight/2 + minus_height;
	b.origin.y = stepHeight/2;
	b.origin.x = CEC_TEXTMARGIN;
	b.size.width -= CEC_TEXTMARGIN * 2;
	if (b.size.height < 0)
	{
		b.size.height = 0;
	}
	if (b.size.width < 0)
	{
		b.size.width = 0;
	}


	/* hack */
	/*
	NSRect r = [self bounds];
	NSSize size;
	size = [_str size];

	if (NSWidth(r) < size.width)
	{
		if (NSHeight(r) > NSWidth(r))
		{
			b.origin.x = size.height;
			b.size.width -= size.height;
			b.size.height += size.height/2;
		}
	}
	*/

	[_scrollView setFrame:b];
	b.origin = NSZeroPoint;
	[_textView setFrame:b];

	[[_textView textContainer] setContainerSize: NSMakeSize (b.size.width,
			                                                           1e7)];
	[[_textView textContainer] setWidthTracksTextView: NO];

	[_textView setMaxSize: NSMakeSize (1, 1E7)];

}

- (void) setFrame:(NSRect)f
{
	[super setFrame:f];
	[self _frameChanged];
}

#define CEC_BORDERSIZE 1

- (void) drawRect:(NSRect)r
{
	int i,j;
	float hline;
	float rad;

	r = [self bounds];

	rad = [__owner stepHeight]/2;
	if ((rad + CEC_BORDERSIZE) > NSHeight(r)/2)
	{
		rad = NSHeight(r)/2 - CEC_BORDERSIZE;
	}

	/*
	if (_isSelected)
	{
		rad = rad - CEC_BORDERSIZE;
	}
	*/


	PSnewpath();
	PSmoveto(rad + CEC_BORDERSIZE, CEC_BORDERSIZE);
	PSrcurveto( -rad, 0, -rad, rad, -rad, rad);

	PSrlineto(0,NSHeight(r) - 2 * (rad + CEC_BORDERSIZE));
	PSrcurveto( 0, rad, rad, rad, rad, rad);

	PSrlineto(NSWidth(r) - 2 * (rad + CEC_BORDERSIZE),0);
	PSrcurveto( rad, 0, rad, -rad, rad, -rad);

	PSrlineto(0, -NSHeight(r) + 2 * (rad + CEC_BORDERSIZE));
	PSrcurveto( 0, -rad, -rad, -rad, -rad, -rad);

	PSclosepath();
	PSgsave();

		if (_isSelected)
		{
			[[NSColor yellowColor] set];
			PSsetalpha(0.8);
		}
		else
		{
			if (_isFaded)
			{
				[[NSColor greenColor] set];
				PSsetalpha(0.1);
			}
			else
			{
				[[NSColor whiteColor] set];
				PSsetalpha(0.85);
			}
		}

		PSfill();

	PSgrestore();


	PSgsave();
		NSSize size = [_str size];
		float minus_height = 0;
		if (NSMaxY(_frame) > NSHeight([_super_view bounds]))
		{
			minus_height = NSMaxY(_frame) - NSHeight([_super_view bounds]);
		}

		[_str drawAtPoint:NSMakePoint(rad,
				NSHeight(r) - size.height - minus_height)];

		size = [_str2 size];
		minus_height = 0;
		if (NSMinY(_frame) < 0)
		{
			minus_height = - NSMinY(_frame);
		}

		if (_isSelected)
		{
			[_str2 drawAtPoint:NSMakePoint(NSWidth(r) - size.width - rad,
					minus_height)];
		}

	PSgrestore();

	[[NSColor blackColor] set];


	PSsetlinewidth(CEC_BORDERSIZE * 2);

	PSstroke();


}

- (void) setFaded:(BOOL)fade
{
	_isFaded = fade;
	[self setNeedsDisplay:YES];
}

- (void) setSelected:(BOOL)select
{
	_isSelected = select;
	if (select == NO)
	{
		_isEdited = NO;
		[_textView setDrawsBackground:NO];
		[_textView setEditable:NO];
		[self _frameChanged];
	}

	[self setNeedsDisplay:YES];
}

- (void) setNeedsDisplay:(BOOL)y
{
	[_super_view setNeedsDisplay:y];
}

#if 0
- (NSComparisonResult) compareBySelected:(CalendarEventCell *)otherCell
{
	if (_isSelected)
	{
		return NSOrderedDescending;
	}
	else if ([otherCell isSelected])
	{
		return NSOrderedAscending;
	}

	return NSOrderedSame;
}
#endif

- (BOOL) isSelected
{
	return _isSelected;
}

- (NSView *)hitTest:(NSPoint)aPoint
{
	id hitView;
	hitView = [super hitTest:aPoint];

	if (_isEdited && (hitView == _textView))
	{
		/* is being edited */
		return _textView;
	}

	if (hitView != nil)
	{
		return self;
	}

	return nil;
}

- (NSComparisonResult) compare: (CalendarEventCell *)otherCell
{
	NSComparisonResult result = [__model compare:[otherCell calendarEventModel]];

	return result;
}

- (void) mouseDown:(NSEvent *)event
{
	[super mouseDown:event];
	_isEdited = NO;
	[_textView setDrawsBackground:NO];
	if ([event clickCount] == 2)
	{
//		NSLog(@"edit %@",NSStringFromRect([_textView frame]));
		[self edit];
	}
}

- (void) edit
{
	_isEdited = YES;
	[_textView setDrawsBackground:YES];
	[_textView setEditable:YES];
	[[self window] makeFirstResponder: _textView];
}

- (NSString *) stringValue
{
	return [_textView string];
}

/*
- (void) mouseUp:(NSEvent *)event
{
}
*/


/** dates **/

- (void) setStartDate:(NSCalendarDate *)startDate
		 timeInterval:(NSTimeInterval)stopTime
{
	[__model setStartDate:startDate
			 timeInterval:stopTime];
}

/** <CalendarEventModel> **/
- (void) calendarEventModel:(CalendarEventModel *)model
		 didUpdateStartDate:(NSCalendarDate *)startDate
			   timeInterval:(NSTimeInterval)time
{
	[self calculateFrameHeight];
}

- (void) calendarEventModelWillBeFreed:(id)model
{
	__model = nil;
	[self removeFromSuperview];
}

- (id) calendarEventModel
{
	return __model;
}
/****/

- (NSCalendarDate *) startDate
{
	return [__model startDate];
}

- (void) setTimeInterval:(NSTimeInterval)stopTime
{
	[__model setTimeInterval:stopTime];
}

- (NSTimeInterval) timeInterval
{
	return [__model timeInterval];
}

- (NSCalendarDate *) stopDate
{
	return [__model stopDate];
}

- (NSCalendarDate *) createDate
{
	return [__model createDate];
}

- (NSCalendarDate *) modifyDate
{
	return [__model modifyDate];
}

/***/

- (void) hide
{
	[self setFrameOrigin:NSMakePoint(-1000,-1000)];
	[self setNeedsDisplay:YES];
}

- (void) calculateFrameHeight
{
	NSCalendarDate *mStartDate;
	NSCalendarDate *mStopDate;
	NSTimeInterval mTimeInterval;
	NSCalendarDate *ownerDate;

	mStartDate = [__model startDate];
	mStopDate = [__model stopDate];
	mTimeInterval = [__model timeInterval];
	ownerDate = [__owner startDate];


	NSCalendarDate *stopDate;
	NSCalendarDate *length;

	if ([[ownerDate addTimeInterval:CEC_VIEWSECONDS] compare:mStartDate] <= NSOrderedSame || 
				 [ownerDate compare:mStopDate] >= NSOrderedSame)
	{
		return;
	}

	length = [ownerDate addTimeInterval:mTimeInterval];

	
	RELEASE(_str);
	RELEASE(_str2);
	_str = [[NSMutableAttributedString alloc] initWithString:[NSString stringWithFormat:@"%02d:%02d",[[__model startDate] hourOfDay],[[__model startDate] minuteOfHour]]];
	_str2 = [[NSMutableAttributedString alloc] initWithString:[NSString stringWithFormat:@"%02d:%02d",[mStopDate hourOfDay],[mStopDate minuteOfHour]]];

	[_str addAttribute:NSFontAttributeName
				 value:[NSFont boldSystemFontOfSize:9]
				 range:NSMakeRange(0,[_str length])];

	[_str addAttribute:NSForegroundColorAttributeName
				 value:[NSColor blackColor]
				 range:NSMakeRange(0,[_str length])];

	[_str2 addAttribute:NSFontAttributeName
				 value:[NSFont boldSystemFontOfSize:9]
				 range:NSMakeRange(0,[_str2 length])];

	[_str2 addAttribute:NSForegroundColorAttributeName
				 value:[NSColor blackColor]
				 range:NSMakeRange(0,[_str2 length])];

	float hSize = [__owner stepHeight] * mTimeInterval / CEC_STEPSECONDS;
	if (hSize < [_str size].height)
	{
		hSize = [_str size].height;
	}

	NSRect f = NSMakeRect(NSMinX(_frame),
			(CEV_BORDERSIZE  + (CEC_UNITHEIGHT * [__owner numberOfUnits])) - 
			([mStartDate timeIntervalSinceDate:ownerDate] + mTimeInterval) /
			([__owner numberOfMinutesInStep] * 60) * [__owner stepHeight],
			NSWidth(_frame),
			hSize);

	[self setFrame:f];
	[self setNeedsDisplay:YES];
}


- (id) delegate
{
	return (_delegate);
}

- (void) setDelegate:(id)del
{
	ASSIGN(_delegate, del);
}

@end
