#include "CalendarManager.h"
#include "CalendarEvent.h"

@implementation CalendarManager

+ (id) calendarManagerWithDomainNamed:(NSString *)domainName
			 authenticateWithUserName:(NSString *)userName
							 password:(NSString *)password
{
	id _domainName;
	id _userName;
	id _password;

	id domain;
	id user;

	CalendarManager *newMan;

	_domainName = [NSString stringWithString:domainName];
	_userName = [NSString stringWithString:userName];
	_password = [NSString stringWithString:password];

	domain = [CalendarDomain calendarDomainNamed:_domainName];

	/* domain doesn't existed */
	if (domain == nil)
	{
		NSLog(@"domain doesn't existed");
		return nil;
	}
	NSLog(@"authen user '%@' in domain '%@'", _userName, _domainName);

	user = [CalendarUser calendarUserWithCalendarDomain:domain
											   userName:_userName
											   password:_password
											   timeZone:nil
											   infoDict:nil];

	if (user == nil)
	{
		NSLog(@"Authentication failed");
		return nil;
	}

	[user setCurrentCalendarUser];

	newMan = (CalendarManager *)NSAllocateObject(self, 0, NSDefaultMallocZone());
	return AUTORELEASE(newMan);
}

- (void) dealloc
{
	
	NSLog(@"deallocate manager for user '%@' of domain '%@'", [CURUSR name], [CURDOM name]);
	[CalendarUser resetCurrentCalendarUser];
	[super dealloc];
}

- (id <CalendarUser>) calendarUser
{
	return AUTORELEASE([[CalendarUserManager alloc] initWithCalendarUser:CURUSR]);
}

#if 0
- (void) doThreadQuery:(id)object
{
	CREATE_AUTORELEASE_POOL(p);
	[object query];
	RELEASE(p);
}

- (void) query:(id) object
{
	NSLog(@"%d",[NSConnection defaultConnection]);
	[object query];

	/*
	[NSThread detachNewThreadSelector:@selector(doThreadQuery:)
							 toTarget:self
						   withObject:object];
						   */
}
#endif

/*
- (void) setCalendarUser:(id <CalendarUser>) user
{

	if (![_user canPerform:_cmd
				  onObject:_domain])
	{
		return;
	}

	CalendarUser *newUser;
	NSString *login, *password;
	NSDictionary *info;
	NSTimeZone *userTimeZone = [user timeZone];

	login = password = nil;
	if (userTimeZone != nil)
	{
		userTimeZone = AUTORELEASE([[NSTimeZone alloc] initWithName:[userTimeZone timeZoneName]]);
	}

	if ([user name])
	{
		login = [NSString stringWithString:[user name]];
	}

	if ([login isEqualToString:[_user name]] == NO && [_user isRoot] == NO)
	{
		return;
	}

	if ([user password])
	{
		password = [NSString stringWithString:[user password]];
	}

	newUser = [CalendarUser
		calendarUserWithName:login
					password:password
					timeZone:userTimeZone
					userInfo:[NSDictionary
								dictionaryWithDictionary:[user userInfo]]];

	[_domain setCalendarUser: newUser];
}
*/


#if 0
- (NSDictionary *) serverInformationDictionary
{
	NSMutableDictionary *infoDict;
	NSMutableArray *array;
	NSEnumerator *en;
	id obj;
	infoDict = [NSMutableDictionary dictionary];

	[infoDict setObject:[_domain name] forKey:@"Name"];
	array = [NSMutableArray array];

	/*
	en = [[_user calendarGroups] objectEnumerator];
	while (obj = [en nextObject])
	{
		[array addObject:[obj description]];
	}

	[infoDict setObject:array
				 forKey:[@"GroupInfo:" stringByAppendingString:[_user name]]];

	if (_isRoot)
	{
		CalendarUser *user;
		en = [[_domain allUsers] objectEnumerator];
		while (user = [en nextObject])
		{
			NSString *name;
			name = [user name];
			NSLog(@"name %@",name);

			if ([name isEqualToString:@""])
			{
				name = @"AdminInfo";
			}
			else
			{
				name = [NSString stringWithFormat:@"UserInfo:%@",name];
			}

			NSMutableDictionary *retdict;
			retdict = [NSMutableDictionary dictionaryWithDictionary:[user userInfo]];
			[retdict setObject:[[user timeZone] description]
						forKey:@"TimeZone"];
			[infoDict setObject:retdict
						 forKey:name];
		}
	}
	else
	{
		NSMutableDictionary *retdict;
		retdict = [NSMutableDictionary dictionaryWithDictionary:[_user userInfo]];
		[retdict setObject:[[_user timeZone] description]
					forKey:@"TimeZone"];
		[infoDict setObject:retdict
					 forKey:@"UserInfo"];
	}
	*/


	return infoDict;
}
#endif


/* reuse error message code if possible
 
- (id) initWithDomainName:(NSString *)name
 authenticateWithUserName:(NSString *)userName
				 password:(NSString *)password
{
	CalendarUser *user;

	_isRoot = NO;

	ASSIGN(_domain, [CalendarDomain calendarDomainForDomainName:(NSString *)name]);
	if (_domain == nil)
	{
		NSLog(@"Authentication failure for user `%@@%@'", userName,name);
		NSLog(@"Domain \"%@\" does not exists.", name);
		AUTORELEASE(self);

		return [[NSArray alloc] initWithObjects:@"1", @"Domain does not exists", nil];
	}

	user = [_domain calendarUserWithName:userName];
	if (user == nil)
	{
		NSLog(@"Authentication failure for user `%@@%@'", userName,name);
		NSLog(@"User does not exists");
		AUTORELEASE(self);
		return [[NSArray alloc] initWithObjects:@"2", @"User does not exists", nil];
	}

	if ([[user password] isEqualToString:pswd] != YES)
	{
		NSLog(@"Authentication failure for user `%@@%@'", userName,name);
		NSLog(@"Incorrect password");
		AUTORELEASE(self);
		return [[NSArray alloc] initWithObjects:@"3", @"Incorrect password", nil];
	}

	NSLog(@"Authentication success for user `%@@%@'", userName,name);

	if ([[user name] isEqualToString:@""])
	{
		_isRoot = YES;
	}

	ASSIGN(_user, user);
	return self;
}
*/


#if 0
- (void) dealloc
{
	RELEASE(_user);
	RELEASE(_domain);
	[super dealloc];
}

- (BOOL) isRoot
{
	return _isRoot;
}

- (BOOL) isForUser:(CalendarUser *)user
{
	return user == _user || _isRoot? YES:NO;
}

- (id <CalendarUser>) calendarUserWithName:name
{
	CalendarUser *user;
	user = [_domain calendarUserWithName:name];
	if (user == nil)
	{
		return nil;
	}

	return AUTORELEASE([[CalendarUserManager alloc] initWithCalendarUser:user
													manageByCalendarUser:_user]);
}


- (NSArray *) synchronizeCalendarEvents:(NSArray *)array
{
	NSMutableArray *sArray;
	NSEnumerator *en;
	CalendarEvent *ev;

	en = [array objectEnumerator];

	while (ev = [en nextObject])
	{
		[self setCalendarEvent:ev];
	}

}



- (void) setCalendarEvent:(id <CalendarEvent>) event
{

	/* permission checking comes through this */
	CalendarUser *owner;
	NSString *ownerName;

	owner = [_domain calendarUserWithName:[[event owner] name]];

	if (owner == nil)
	{
		NSLog(@"Unknown user %@ sync event %@", [[event owner] name], [event name]);
	}

	ownerName = [owner name];

	NSLog(@"User %@ sync event %@", ownerName, [event name]);

	if (_isRoot || [ownerName isEqualToString:[_user name]])
	{
		CalendarEvent *newev;

		newev = [CalendarEvent calendarEventWithName:[event name]
									  calendarDomain:_domain
										calendarUser:[_domain calendarUserWithName:ownerName]
									   calendarGroup:[owner calendarGroupWithName:[[event calendarGroup] name]]
										   startDate:[NSDate dateWithTimeIntervalSinceReferenceDate:[[event startDate] timeIntervalSinceReferenceDate]]
											stopDate:[NSDate dateWithTimeIntervalSinceReferenceDate:[[event stopDate] timeIntervalSinceReferenceDate]]
									   summaryString:[event summaryString]];

		[owner setCalendarEvent:newev];
	}
}
#endif

@end
