C	[%!$&\'\(\)\*\+,\-./0-9;=?A-Za-z_]
L	[a-zA-Z0-9_]

%{

/*
C	[a-zA-Z0-9\\\*=$%&/!\^\~;:.,\?\{\}\(\)\[\]\<\>\-\+\*\|\'\`]
*/
/*
"\ "\\*=$%&/!\^~;:.,?\{\}\(\)\[\]\<\>-+*\|\'\`]
typedef union {
	char* s;
	}  YYSTYPE;
extern YYSTYPE yylval;


"/"({C}|{PC})+ {
  return (TNAME);
}

*/

/* aide, Advanced Intrusion Detection Environment
 *
 * Copyright (C) 1999 Rami Lehti,Pablo Virolainen
 * $Header: /cvs-root-aide/aide/src/db_lex.l,v 1.11 2000/05/05 12:59:53 rammer Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#define YY_DECL int db_scan(void)


#define YYDEBUG

#include "conf_yacc.h"
#include <string.h>
#include "report.h"

long db_lineno=1;

%}

%%

^"\037\213" {
  return (TGZIPHEADER);
}

"@@db_spec" {
  return (TDBSPEC);
}

"@@"({L}+) {
  return (TUNKNOWN);
}

"#"[^\n]*"\n" {
  db_lineno++;
}

({C})+ {

 error(230," %s \n",yytext);

 return (TID);
}

[" "\t] {}

"\n" {
 db_lineno++;
 return (TNEWLINE);
}

[^\n] {
 return (TERROR);
}

<<EOF>> {
	return (TEOF);
	}
	

%%

int dbwrap(){
  return 1;
}

void db_buff(FILE* f){

 yy_switch_to_buffer(yy_create_buffer( f, YY_BUF_SIZE ) );

}
