#ifndef _LEXTREE_H
#define _LEXTREE_H

#include "entity.h"

struct lex_holder
{   char   *key;
    Entity *data;
    lex_holder *letters[27];  // pointer for each letter of alphabet, and
                              // one for non-alpha chars 
    int indexltr;
    lex_holder *next;
};

class lextree
{
public:
   lextree();
   ~lextree();

   int    add(char *key,Entity *data);
   int    del(char *key);
   Entity *find(char *key);
   Entity *find_abbrev(char *key);
   bool   can_find(char *key);

   int    clr_list();

   int    show();
   void   reset_current();
   Entity *get_next();

private:
   int add_node(lex_holder **baseptr,lex_holder *newnode, int cur_offset);
   Entity *find_node(lex_holder *baseptr, char *key, int cur_offset);
   Entity *find_node_abbrev(lex_holder *baseptr, char *key, int cur_offset);
   int free_node(lex_holder *the_node);
   int    get_slot(char the_char);
   int   show_node(lex_holder *baseptr, int level);

   // The start of all the mess, the root of the tree.
   lex_holder *root;		
   lex_holder *last_added;
   lex_holder *next_in_list;

   lex_holder *list_root;
   lex_holder *current_node;
};

#endif

