#ifndef _LOG_H
#define _LOG_H

#include <stdio.h>
#include "mudtypes.h"
#include "pager.h"
#include "dirread.h"

#define LOGTEMPNAME1 "temp1.txt"
#define LOGTEMPNAME2 "temp2.txt"

class Logs
{
public:
   int open_log(char *filename);
   ~Logs();
   Logs();
   int display_log(Connection *the_user, char *filename, int num_lines, 
                        Strings *keyword_str, int all, int pager_lines);
   int archive_log(char *filename);
   int is_valid();

protected:

   char logname[MAXFILENAMELEN];
   FILE *the_log;
   int valid;

private:
   int generate_tempfile(DirRead *the_dir, FILE *writefile, Strings *keywords[], 
			 int num_keywords);
   int search_logfile(FILE *readfile, FILE *writefile, Strings *keywords[],
		      int num_keywords);

};

#endif






