#ifndef _VERB_LIST_H
#define _VERB_LIST_H

#include "verb.h"
#include "btree_l.h"
#include "lextree.h"
#include "builder.h"
#include "errlog.h"

#define STATS_VERB_STORE 5

class Verb_List {
 public:

   Verb_List(verb_data verbdata[]);
   ~Verb_List();

   Entity *get_verb(char *command);

   int display_data(Player *the_player);
   int load_actions(FILE *the_file, Builder *the_builder, 
                                 ErrLog *error_log, int is_builder);
   int load_abilities(FILE *the_file, Builder *the_builder, 
                                 ErrLog *error_log, int is_builder);
   int load_chatlines(FILE *the_file, Builder *the_builder, 
                      ErrLog *error_log, int is_builder, int lineflag);
   int add_new_execute(Verb *the_verb, long timespan);
   int add_init_chatlines(Player *the_player);
   int display_verb_stats(Player *the_player);

 private:

   Verb_List();
   Entity *find_verb(char *command);
 
   lextree the_verbs;

   int num_verbs_loaded;

   long num_lookups;
   long max_lookup;
   long avg_lookup;
   long min_lookup;

   long num_executes;
   long max_execute;
   long min_execute;
   long avg_execute;
};

#endif
