/****************************************************************************
 ** Converter CONFIGURATION FILE
 **
 ** This is the main configuration file for the zone converter
 ** 
 ****************************************************************************/
#ifndef _CONVCONFIG_H_
#define _CONVCONFIG_H_

#include "../../include/lexer.h"
#include "../../include/flags.h"

#define CONV_VERSION    "AIME Converter v0.59"

#define DEF_RELOAD_INT  1800  /* the default reload interval in secs */

#define DEF_AREA_FLAGS1 0     /* the default area flags, first element */
#define DEF_AREA_FLAGS2 0     /* the default area flags, second element */

#define DEF_STRENGTH    10
#define DEF_DEXTERITY   10
#define DEF_MAXHEALTH   100
#define DEF_INTEL       10

#undef  LONG_LIST_CONV  // Do we display scrolled objects converted?

// We change a few new functions so we can include strings.cpp and lexer.cpp
#ifdef CONVERTER

inline token_record *new_token_record() { return (new token_record); };
inline char *new_char(int num_char) { return new char[num_char]; };
inline token_data *new_token_data() { return new token_data; };
inline string_record *new_string_record() { return new string_record; };
inline flag_long_int *new_flag_long_int() { return new flag_long_int; };

inline void delete_flag_long_int(flag_long_int *the_obj) { delete the_obj; };
inline void delete_string_record(string_record *the_obj) { delete the_obj; };
inline void delete_token_data(token_data *the_obj) { delete the_obj; };
inline void delete_char(char *the_char) { delete the_char; };
inline void delete_token_record(token_record *the_token) { delete the_token; };

#endif

#endif



