// aime_w32Dlg.cpp : implementation file
//

#include <sys/types.h>
#include <sys/stat.h>

#include "stdafx.h"
#include "aime_w32.h"
#include "aime_w32Dlg.h"
#include "global.h"
#include "newfuncts.h"
#include "syslog.h"
#include "data_log.h"
#include "config.h"
#include "askyesno.h"
#include "memchk.h"
#include "converter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global Defines
/////////////////////////////////////////////////////////////////////////////

CAime_w32Dlg *main_dlg;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAime_w32Dlg dialog

CAime_w32Dlg::CAime_w32Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAime_w32Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAime_w32Dlg)
	m_log_screen = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	stage = 0;
}

void CAime_w32Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAime_w32Dlg)
	DDX_Control(pDX, IDC_LOG_SCREEN, m_log_ctrl);
	DDX_Control(pDX, IDC_STARTUP, m_startup);
	DDX_Control(pDX, IDC_HALT, m_halt);
	DDX_Text(pDX, IDC_LOG_SCREEN, m_log_screen);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAime_w32Dlg, CDialog)
	//{{AFX_MSG_MAP(CAime_w32Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_STARTUP, OnStartup)
	ON_BN_CLICKED(IDC_HALT, OnHalt)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_COMMAND(ID_SERVER_STARTSERVER, OnServerStartserver)
	ON_COMMAND(ID_SERVER_HALTSERVER, OnServerHaltserver)
	ON_COMMAND(ID_TOOLS_CONVERTER, OnToolsConverter)
	ON_COMMAND(ID_SERVER_EXIT, OnServerExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAime_w32Dlg message handlers

BOOL CAime_w32Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CString holder;

	main_dlg = this;
	is_exiting = FALSE;
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	holder.Format(
  "\r\n\r\n------------------------------------------------------------------------------------------------\r\n"
  "Advanced Interactive Mudding Environment version: %s \r\n"
  "Copyright (C) 2000 George Noel (Slate), Ed Boraas, Kelly Gerke\r\n"
  "Free Software licensed under the GNU General Public License\r\n"
  "--------------------------------------------------------------------------------------------\r\n\r\n",

    FULLVERSION);
   sysmessage(holder);

   sysmessage("Reading in config file...");

   if (the_config.load_configs() <= 0)
   {
	  AfxMessageBox("Error in config file.  Can't continue.");
      exit(0);
   }
   sysmessage("Done.\r\n");

   sysmessage("Checking for necessary files...");
   check_for_files(false);
   sysmessage("Done.\r\n");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAime_w32Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAime_w32Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.

HCURSOR CAime_w32Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAime_w32Dlg::OnStartup() 
{
	m_halt.EnableWindow(TRUE);
	m_startup.EnableWindow(FALSE);

	mainstruct = new_Mud(false);
	initiate_startup();
}

void CAime_w32Dlg::OnHalt() 
{
	m_halt.EnableWindow(FALSE);

	initiate_halt();
}

void CAime_w32Dlg::initiate_startup()
{
	stage = STAGE_CLEAN;
	SetTimer(TIMER_STARTUP, 10, NULL);
}

void CAime_w32Dlg::OnTimer(UINT nIDEvent) 
{
	CString holder;
	int results;

	if (nIDEvent == TIMER_STARTUP)
	{
		KillTimer(TIMER_STARTUP);
		stage++;
		switch(stage)
		{
			case STAGE_ERRLOG:
				sysmessage("Opening Logs:\r\n\tOpening Error Log...");
				mainstruct->startup_stage(STAGE_ERRLOG, FALSE);
				if (!(mainstruct->get_log()->is_valid()))
				{
					AfxMessageBox("Error opening Error log.  Halting startup.");
					initiate_halt();
					return;
				}
				sysmessage("Opened.\r\n");
				SetTimer(TIMER_STARTUP, 10, NULL);
				break;

			case STAGE_SYSLOG:
				sysmessage("\tOpening System Log...");
				mainstruct->startup_stage(STAGE_SYSLOG, FALSE);
				if (!(mainstruct->get_syslog()->is_valid()))
				{
					AfxMessageBox("Error opening System log.  Halting startup.");
					initiate_halt();
					return;
				}
				sysmessage("Opened.\r\n");
				SetTimer(TIMER_STARTUP, 10, NULL);
				break;

			case STAGE_SUGGLOG:
				sysmessage("\tOpening Suggestions Log...");
				mainstruct->startup_stage(STAGE_SUGGLOG, FALSE);
				if (!(mainstruct->get_suggestlog()->is_valid()))
				{
					AfxMessageBox("Error opening Suggestions log.  Halting startup.");
					initiate_halt();
					return;
				}
				sysmessage("Opened.\r\n");
				SetTimer(TIMER_STARTUP, 10, NULL);
				break;

			case STAGE_BUGLOG:
				sysmessage("\tOpening Bug Log...");
				mainstruct->startup_stage(STAGE_BUGLOG, FALSE);
				if (!(mainstruct->get_buglog()->is_valid()))
				{
					AfxMessageBox("Error opening Bug log.  Halting startup.");
					initiate_halt();
					return;
				}
				sysmessage("Opened.\r\n");
				SetTimer(TIMER_STARTUP, 10, NULL);
				break;

			case STAGE_TYPOLOG:
				sysmessage("\tOpening Typo Log...");
				mainstruct->startup_stage(STAGE_TYPOLOG, FALSE);
				if (!(mainstruct->get_typolog()->is_valid()))
				{
					AfxMessageBox("Error opening Typo log.  Halting startup.");
					initiate_halt();
					return;
				}
				sysmessage("Opened.\r\nLog Startup Complete\r\n");
				SetTimer(TIMER_STARTUP, 10, NULL);
				break;

			case STAGE_BOOTSTRAP:

				if (mainstruct->get_boot_status() == 0)
					sysmessage("Bootstrapping Mud Data:\r\n");
				mainstruct->set_boot_status(mainstruct->get_boot_status() + 1);

				if ((results = mainstruct->bootstrap(FALSE, mainstruct->get_boot_status())) == -1)
				{
					AfxMessageBox("Error bootstrapping.  Failed.");
					initiate_halt();
					return;
				}

				// If it is locked, we just reset the timer and try again later
				else if (results == 0)
				{
					SetTimer(TIMER_STARTUP, 10, NULL);
					stage--;
					return;
				}

				if (mainstruct->get_boot_status() != STAT_GAMEREADY)
					stage--;
				else
					sysmessage("Bootstrapping Complete.\r\n");

				SetTimer(TIMER_STARTUP, 10, NULL);
				break;

			case STAGE_USERDBASE:

				sysmessage("Loading User Database...");
				if (mainstruct->startup_stage(STAGE_USERDBASE, FALSE) == -1)
				{
					AfxMessageBox("Error loading User Database.  Halting Startup.");
					initiate_halt();
					return;
				}
				sysmessage("Complete.\r\n");

				SetTimer(TIMER_STARTUP, 10, NULL);
				break;

			case STAGE_GAMEPORT:

				sysmessage("Initializing listening ports:\r\n\tGame Port...");
				if (mainstruct->startup_stage(STAGE_GAMEPORT, FALSE) == -1)
				{
					AfxMessageBox("Error initializing game listening port.  Halting Startup.");
					initiate_halt();
					return;
				}

				SetTimer(TIMER_STARTUP, 10, NULL);
				break;

			case STAGE_BUILDPORT:

				SetTimer(TIMER_STARTUP, 10, NULL);
				sysmessage("\tBuilder Port...");
				if (mainstruct->startup_stage(STAGE_BUILDPORT, FALSE) == -1)
				{
					AfxMessageBox("Error initializing builder listening port.  Halting Startup.");
					initiate_halt();
					return;
				}
				sysmessage("All Ports Initialized.\r\n");

				break;

			case STAGE_ACCESSLIST:

				sysmessage("Loading Access Lists...");
				if (mainstruct->startup_stage(STAGE_ACCESSLIST, FALSE) == -1)
				{
					AfxMessageBox("Error loading access lists.  Halting Startup.");
					initiate_halt();
					return;
				}
				sysmessage("Loaded.\r\n");
				SetTimer(TIMER_STARTUP, 10, NULL);

				break;

			case STAGE_RUNGAME:
				sysmessage("Starting game cycle...");
				SetTimer(TIMER_GAMECYCLE, ((int) (((float) 1000) / 
					                                ((float) the_config.pollspersec))), NULL);
				sysmessage("Started.\r\nGame Successfully Started.\r\n\r\n");
				break;

			default:
				break;
		}
	}
	else if (nIDEvent == TIMER_HALT)
	{
		KillTimer(TIMER_HALT);
		switch(stage)
		{
			case STAGE_ERRLOG:
				sysmessage("\tClosing Error Log...");
				mainstruct->shutdown_stage(STAGE_ERRLOG);
				sysmessage("Closed.\r\n");
				sysmessage("Closed.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_SYSLOG:
				sysmessage("\tClosing System Log...");
				mainstruct->shutdown_stage(STAGE_SYSLOG);
				sysmessage("Closed.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_SUGGLOG:
				sysmessage("\tClosing Suggestions Log...");
				mainstruct->shutdown_stage(STAGE_SUGGLOG);
				sysmessage("Closed.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_BUGLOG:
				sysmessage("\tClosing Bug Log...");
				mainstruct->shutdown_stage(STAGE_BUGLOG);
				sysmessage("Closed.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_TYPOLOG:
				sysmessage("Closing Logs:\r\n\tClosing Typo Log...");
				mainstruct->shutdown_stage(STAGE_TYPOLOG);
				sysmessage("Closed.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_BOOTSTRAP:
				if (mainstruct->get_boot_status() == STAT_GAMEREADY)
					sysmessage("Deleting Mud Data:\r\n");

				mainstruct->shutdown_stage(STAGE_BOOTSTRAP);
				SetTimer(TIMER_HALT, 10, NULL);
				if (mainstruct->get_boot_status() != 0)
				{
					stage++;
				}
				else
				{
					sysmessage("Deleted\r\n");
				}
				break;

			case STAGE_USERDBASE:
				sysmessage("Deleting User Database...");
				mainstruct->shutdown_stage(STAGE_USERDBASE);
				sysmessage("Deleted.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_GAMEPORT:
				sysmessage("\tShutting Down Game port...");
				mainstruct->shutdown_stage(STAGE_GAMEPORT);
				sysmessage("Closed.\r\nAll Ports Shutdown.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_BUILDPORT:
				sysmessage("Shutting Down Ports:\r\n");
				sysmessage("\tShutting Down Builder port...");
				mainstruct->shutdown_stage(STAGE_BUILDPORT);
				sysmessage("Closed.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_ACCESSLIST:
				sysmessage("Removing Access Lists...");
				mainstruct->shutdown_stage(STAGE_ACCESSLIST);
				sysmessage("Removed.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_RUNGAME:
				sysmessage("Stopping game cycle...");
				KillTimer(TIMER_GAMECYCLE);
				sysmessage("Stopped.\r\n");
				SetTimer(TIMER_HALT, 10, NULL);
				break;

			case STAGE_CLEAN:
				delete_Mud(mainstruct);
				m_startup.EnableWindow(TRUE);
				mainstruct = NULL;
				if (is_exiting)
					exit(1);
				break;

			default:
				break;
		}
		stage--;
	}
	else if (nIDEvent == TIMER_GAMECYCLE)
	{
		gameTimer.handle_timer();
	}
	CDialog::OnTimer(nIDEvent);
}

BOOL CAime_w32Dlg::sysmessage(CString the_message)
{
	m_log_screen += the_message;
	UpdateData(FALSE);
	m_log_ctrl.LineScroll(m_log_ctrl.GetLineCount());
	return TRUE;
}

void CAime_w32Dlg::initiate_halt()
{
	if ((is_exiting) && (stage <= STAGE_CLEAN))
		exit(1);

	SetTimer(TIMER_HALT, 10, NULL);
}

void CAime_w32Dlg::check_for_files(bool quiet_mode)
{
   Strings user_dir;
   Strings holder;
   char    char_counter[ 2 ];
   int     usr_missing = 0;
   long    lAttr;

   if (!quiet_mode)
   {
      sysmessage(_("Looking for necessary directories..."));
      fflush(stdout);
   }

   check_directory(DATA_DIR, "Data");
   check_directory(AREADIR, "Area");
   check_directory(BLDRDIR, "Builder");
   check_directory(BULLETINDIR, "Bulletin");
   check_directory(LOGDIR, "Log");
   check_directory(LOGARCHIVE, "Log archive");
   check_directory(LOGDIR, "Log");
   check_directory(USERDATADIR, "Users");

   strcpy( char_counter, "a" );
   while( *char_counter <= (int)'z' )
   {
      user_dir = the_config.basedir.str_show();
      user_dir.str_cat("\\");
      user_dir.str_cat( USERDATADIR );
      user_dir.str_cat( "\\" );
      user_dir.str_cat( char_counter );

      lAttr = GetFileAttributes( user_dir.str_show( ) );
      if(    lAttr == 0xFFFFFFFF
          || ( lAttr & FILE_ATTRIBUTE_DIRECTORY ) == 0 ) {
         if( !usr_missing )
         {
            if (get_yes_no("One or more user directories are missing.\r\n"
                   "Would you like to create them?") == FALSE)
			{
               AfxMessageBox("All user directory must exist.  Exiting.");
               exit( 1 );
            }
            usr_missing = 1;
         }      


         if( CreateDirectory( user_dir.str_show( ), NULL ) == 0 )
         {
			 holder.sprintf("Error creating directory %s\n", user_dir.str_show());
            AfxMessageBox(holder.str_show());
            exit( 1 );
         }
      }

      *char_counter = *char_counter + 1;
   }
   if (!quiet_mode)
      sysmessage("Done!\r\n");
   return;
}

void CAime_w32Dlg::check_directory(char *base_path, char *dir_name)
{
   long lAttr;
   Strings fullpath;
   Strings holder;

   fullpath = the_config.basedir.str_show();
   fullpath.str_cat("\\");
   fullpath.str_cat( base_path );

   lAttr = GetFileAttributes( fullpath.str_show( ) );
   if(    lAttr == 0xFFFFFFFF
       || ( lAttr & FILE_ATTRIBUTE_DIRECTORY ) == 0 )
   {
	   if (!strcmp(dir_name, "Data"))
	   {
		   AfxMessageBox("Could not find data directory.  This could be due to an\n"
						 "improper basedir setting in the aime.conf file.  It must be\n"
						 "set to the base directory location of the mud.");
		   exit(0);
	   }

	  holder.sprintf("%s directory missing.  "
             "Would you like to create it? (y/n) ", dir_name);
	  if (get_yes_no(holder.str_show()) == FALSE)
	  {
		  holder.sprintf("%s directory must exist.  Halting.\n", dir_name);
		  sysmessage(holder.str_show());
		   exit(0);
      }      

      if( CreateDirectory( fullpath.str_show( ), NULL ) == 0 )
      {
		 holder.sprintf("Error creating directory %s\n", dir_name );
         sysmessage(holder.str_show());
		   exit(0);
      }
   }
}

BOOL CAime_w32Dlg::get_yes_no(CString the_message)
{
	CAskYesNo dlg;

	dlg.m_message = the_message;
	if (dlg.DoModal() == IDOK)
		return TRUE;
	return FALSE;
}

void CAime_w32Dlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	free_all();	
}

void CAime_w32Dlg::OnServerStartserver() 
{
	OnStartup();
}

void CAime_w32Dlg::OnServerHaltserver() 
{
	OnHalt();	
}

void CAime_w32Dlg::OnToolsConverter() 
{
	CConverter dlg;
	
	dlg.DoModal();
}

void CAime_w32Dlg::OnServerExit() 
{
	is_exiting = TRUE;
	initiate_halt();
}
