#ifndef _ADMINFLAGS_H_
#define _ADMINFLAGS_H_

#define ADMINFLAG_SHOWNAMES        0
#define ADMINFLAG_SHOWMARKERS      1
#define ADMINFLAG_SETAREAS         2
#define ADMINFLAG_SEETCP           3
#define ADMINFLAG_SEELOGIN         4
#define ADMINFLAG_SETOTHERS        5
#define ADMINFLAG_SETENVIRON       6  /* allows to set environment vars like
                                         time of day, weather, etc */
#define ADMINFLAG_SEESLAIN         7
#define ADMINFLAG_SEEQUESTS        8
#define ADMINFLAG_SEELEVEL         9  /* see the players get levels */
#define ADMINFLAG_SEEERRORS       10  /* see when errors are logged */
#define ADMINFLAG_SETOBJECTS      11  /* be able to set object attributes */
#define ADMINFLAG_SEERELOADS      12  /* be able to see zone reloads */
#define ADMINFLAG_BOARDADMIN      13  /* be able to administrate bulletins */
#define ADMINFLAG_ADMINISTRATOR   14  /* is this player an administrator */
#define ADMINFLAG_AUTOASSOCIATE   15  /* for builders, autoassociates an exit
                                         with the opposite exit */
#define ADMINFLAG_SEEBUILDER      16  /* allows users on the game port to see
                                         things on the builder port */
#define ADMINFLAG_NOSPECTATE      17  /* nobody can spectate you on the builder
                                         port */
#define ADMINFLAG_SEELOCATIONS    18  /* set the ability to see what locations
                                         players are in when running users */
#define ADMINFLAG_DELETEUSER      19  /* delete other users from the mud */
#define ADMINFLAG_SEECLONES       20  /* See people cloning stuff */
#define ADMINFLAG_SEEFORCE        21  /* See people being forced */
#define ADMINFLAG_SEEFLAGS        22  /* See people setting other's flags */
#define ADMINFLAG_SEEBHOSTS       23  /* See people modifying the bhosts list */
#define ADMINFLAG_SEEBANHOSTS     24  /* See people modifying the banhosts 
                                         list */
#define ADMINFLAG_SEESLAYS        25  /* See people using the slay command */
#define ADMINFLAG_SEEDELETES      26  /* See others using the delete command */
#define ADMINFLAG_SEEBOOTS        27  /* See people getting booted */
#define ADMINFLAG_BUILDER         28  /* Is this player a builder, needed for
                                         builder port access */
#define ADMINFLAG_SETPROTECTED    29  /* Set attributes like strength protected from
                                         players setting */


#ifdef COMMANDS_C

char *admflagnames[] = {     "ShowNames",   "ShowMarkers", "SetAreas", 
            "SeeTCP",        "SeeLogin",    "SetOthers",   "SetEnviron", 
            "SeeSlain",      "SeeQuests",   "SeeLevel",    "SeeErrors", 
            "SetObjects",    "SeeReloads",  "BoardAdmin",  "Administrator",
	    "AutoAssociate", "SeeBuilder",  "NoSpectate",  "SeeLocations",
            "DeleteUser",    "SeeClones",   "SeeForce",    "SeeFlags",
	    "SeeBhosts",     "SeeBanhosts", "SeeSlays",    "SeeDeletes", 
	    "SeeBoots",      "Builder",     "SetProtected",   NULL};

#else

extern char *admflagnames[];

#endif
#endif




