#ifndef _MERGER_H
#define _MERGER_H

#include "strings.h"
#include "moveable.h"
#include "builder.h"

class Merger : public Moveable
{
public:

   Merger(char *the_name, char *the_area);
   ~Merger();

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int      get_size();
   int      get_weight();
   int      get_orig_size();
   int      get_orig_weight();

   long     get_number_of();
   int      set_number_of(long the_number);

   char     *get_parent();

   int      copy_merger(Merger *copy_from);
   Merger *operator = (Merger *copy_from);

   int      write_merger_attrib(FILE *the_file);
   int      read_merger_attrib(FILE *read_file, ErrLog *error_log);
   int      copy_merger_attrib(Merger *copy_from);
   int      get_mem_size_merger();
   virtual  int get_mem_size();
   virtual  int get_mem_size_dynamic();

 protected:

   Merger();
   long     number_of;
   Strings  parent;

 private:

};

#endif






