#ifndef _RACE_H
#define _RACE_H

#include "mudtypes.h"
#include "strings.h"
#include "errlog.h"
#include "parse.h"
#include "flags.h"
#include "entity.h"
#include "config.h"
#include "specials.h"

class Player;
class Builder;

/* the tutorial class is just a linked list attached to the race.  Most methods
   for this class are handled in the race and it provides the sanity check for
   all functions to prevent messing up this object...race should handle
   interaction with this */

class Tutorial {
 public:
   Tutorial();
   ~Tutorial();
   Tutorial(char *the_name);
   int get_mem_size_dynamic();
   int get_mem_size();

   Strings     name;
   int         sequence;
   Strings     prompt;
   Strings     tutorial_special;
   int         mandatory;   
   special_env the_environment;
   Tutorial    *next_tutorial;
 private:


};

class Race : public Entity {
 public:

   Race();
   virtual ~Race();
   Race(char *quest_name);

   void set_description(char *the_string);
   char *get_description();
   void set_init_desc(char *the_string);
   char *get_init_desc();
   void set_init_brief(char *the_string);
   char *get_init_brief();
   void set_init_ability(char *the_string);
   char *get_init_ability();
   void set_init_location(char *the_string);
   char *get_init_location();
   void set_death_location(char *the_string);
   char *get_death_location();
   void set_death_text(char *the_string);
   char *get_death_text();
   void set_allow_incl(char *the_string);
   char *get_allow_incl();
   void set_allow_talent(char *the_string);
   char *get_allow_talent();
   void set_init_str(int the_num);
   int get_init_str();
   void set_init_dex(int the_num);
   int get_init_dex();
   void set_init_intel(int the_num);
   int get_init_intel();
   void set_init_con(int the_num);
   int get_init_con();
   void set_init_wis(int the_num);
   int get_init_wis();
   void set_init_cha(int the_num);
   int get_init_cha();

   int load_race(FILE *the_file, ErrLog *error_log, int is_builder);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);
   void write_object(FILE *the_file, int is_builder);

   int add_tutorial(char *the_name);
   int del_tutorial(char *the_name);
   Tutorial *get_tutorial(char *the_name);
   Tutorial *copy_tutorial_list();
   int set_tutorial_prompt(char *the_name, char *new_prompt);
   char *get_tutorial_prompt(char *the_name);
   int set_tutorial_name(char *the_name, char *new_name);
   int set_tutorial_special(char *the_name, char *new_special);
   int set_tutorial_sequence(char *the_name, int new_sequence);
   int set_tutorial_mandatory(char *the_name, int new_value);
   int get_tutorial_mandatory(char *the_name);
   int reset_sequence(void);
   int insert_tutorial(Tutorial *the_tutorial);
   char *get_next_tutorial(char *prev_tutorial);
   int start_tutorial(char *the_name, Player *the_player);



   int is_modified();
   void set_modified(int the_num);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();


 private:

   int       modified;

   Strings   description;
   Strings   init_desc;
   Strings   init_brief;
   Strings   init_ability;
   Strings   init_location;
   Strings   death_location;
   Strings   death_text;

   Strings   allow_incl;
   Strings   allow_talent;

   Tutorial  *tutorial_list;

   int       init_str;
   int       init_dex;
   int       init_intel;
   int       init_con;
   int       init_wis;
   int       init_cha;
};

#endif
