/**********************************************************************
 ** Timespan class: performs certain time functions like time elapsed
 **                 since a certain event or since this object was
 **                 created.
 **
 ** Last reviewed: version 0.14
 **
 **
 ** Copyright (C) 2000 George Noel (Slate)
 **
 **   This program is free software; you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as
 **   published by the Free Software Foundation; either version 2 of the 
 **   License, or any later version. 
 **
 **   This program is distributed in the hope that it will be useful, but 
 **   WITHOUT ANY WARRANTY; without even the implied warranty of 
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 **   General Public License for more details. 
 ** 
 **   You should have received a copy of the GNU General Public License 
 **   along with this program (in the docs dir); if not, write to the Free
 **   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 **
 **********************************************************************/

#ifndef TIMESPAN_C
#define TIMESPAN_C

#include "config.h"
#include "sysdep.h"
#include "mudtypes.h"
#include "timespan.h"

/***********************************************************************
 ** Timespan (constructor) - Constructs the timespan object
 **
 ** Parameters: None
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

Timespan::Timespan()
{
   initial_time = time(0);
}

/***********************************************************************
 ** Timespan (constructor) - Constructs the timespan object
 **
 ** Parameters: time_to_use - the time we should use instead of current
 **                           to set the initial time setting
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

Timespan::Timespan(time_t time_to_use)
{
   initial_time = time_to_use;
}

/***********************************************************************
 ** ~Timespan (destructor) - cleans up and destroys the timespan object
 **
 ** Parameters: None
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

Timespan::~Timespan()
{ 
}


/***********************************************************************
 ** time_elapsed - returns the number of seconds elapsed 
 **
 ** Parameters: None 
 **
 ** Returns: num seconds elapsed if success, -1 if error
 **
 ***********************************************************************/

time_t Timespan::elapsed_time(void)
{
   return time(0) - initial_time; 
}


/***********************************************************************
 ** set_time - sets the time to the given time
 **
 ** Parameters: None 
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

void Timespan::set_time(time_t new_time)
{
   initial_time = new_time;
}


/***********************************************************************
 ** reset_time - resets the time to the current time
 **
 ** Parameters: None 
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

void Timespan::reset_time(void)
{
   initial_time = time(0);
}

#endif









