/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdio.h>
#include <signal.h>
#ifndef WIN32
#include <sys/time.h>
#include <semaphore.h>
#else
#include <windows.h>
#endif

#include "interface.h"
#include "support.h"

#ifndef WIN32
void changeChannel(int);
extern sem_t capture_sem; 
extern sem_t malloc_sem; 
#else
VOID CALLBACK changeChannel(HWND, UINT, UINT, DWORD);
int initPeek();
extern HANDLE capture_sem; 
extern HANDLE malloc_sem; 
#endif
void loadOpts();

#include "RC4.h"

int
main (int argc, char *argv[])
{
  //this will be the channel scanning interval, currently 0.2 sec
#ifndef WIN32
  struct itimerval tval;
  struct timeval interval = {0, 200000};
#endif

  GtkWidget *AirSnortWindow;

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  //init some RC4 stuff
  setupIdentity();

//this sets up the channel scanning stuff and some semaphores
#ifndef WIN32
  signal(SIGALRM, changeChannel);
  tval.it_interval = interval;
  tval.it_value = interval;
  setitimer(ITIMER_REAL, &tval, NULL);
  sem_init(&capture_sem, 0, 1);
  sem_init(&malloc_sem, 0, 1);
#else
  SetTimer(NULL, 0, 200, changeChannel); //200 ms timer = 0.2 sec
  if (initPeek()) {
     fprintf(stderr, "Unable to load Peek.dll\n");
     exit(0);
  }
  capture_sem = CreateSemaphore(NULL, 1, 1, NULL);
  malloc_sem = CreateSemaphore(NULL, 1, 1, NULL);
#endif

  //load program options
  loadOpts();

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  AirSnortWindow = create_AirSnortWindow ();
  gtk_widget_show (AirSnortWindow);

  gtk_main ();
  return 0;
}

