from threading import Thread

import gst
import gtk

class RepeatSound(Thread):
	def __init__(self, howmanytimes, button, volume, PlayerInstance):

		Thread.__init__(self)

		self.setDaemon(True)

		self.button = button
		self.times = howmanytimes - 1
		self.bus = PlayerInstance.get_bus()
		self.bus.add_signal_watch()
		self.bus.connect('message', self.BusMessage)
		self.time_format = gst.Format(gst.FORMAT_TIME)
		self.Repeated = 0	
		self.stop = False
		self.volume = volume / 100
		self.PlayerInstance = PlayerInstance

	def run(self):
		
		self.PlayerInstance.set_property("volume", self.volume)
		self.PlayerInstance.set_state(gst.STATE_PLAYING)

		if self.times > -1:
			while self.Repeated < self.times and \
			self.PlayerInstance.get_state()[1] != gst.STATE_NULL:
				if self.times == -1:
					self.Repeated = 0
					continue
				continue
		else:
			while self.PlayerInstance.get_state()[1] != gst.STATE_NULL: continue

		self.PlayerInstance.set_property("volume", 0)
		self.PlayerInstance.set_state(gst.STATE_NULL)
		self.Repeated = 0

		gtk.gdk.threads_enter()
		self.button.set_sensitive(False)
		gtk.gdk.threads_leave()

	def BusMessage(self, Bus, Message):
		if Message.type == gst.MESSAGE_EOS:
			self.PlayerInstance.set_state(gst.STATE_PAUSED)
			self.PlayerInstance.seek_simple(self.time_format, gst.SEEK_FLAG_FLUSH, 0)
			self.PlayerInstance.set_property("volume", self.volume)
			self.PlayerInstance.set_state(gst.STATE_PLAYING)
			self.Repeated += 1


