#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Build and test all listed modules.
#
# The module files must have a function "suite" which returns
# an instance of unittest.TestSuite or unittest.TestCase.
#
# $Id: all.py,v 1.11 2002/07/30 07:33:51 andrewm Exp $

import unittest

class AllTestSuite(unittest.TestSuite):
    # add modules with tests here
    all_tests = [
    	"basic",
    	"control_flow",
        "env",
        "form",
        "include",
        "iterator",
        "lookup",
        "macro",
        "tree",
        "whitespace"
    ]
    def __init__(self):
        unittest.TestSuite.__init__(self)
        for m in map(__import__, self.all_tests):
            self.addTest(m.suite())

if __name__ == '__main__':
    unittest.main(defaultTest='AllTestSuite')
