// ---------------------------------------------------------------------------
// - Main.cpp                                                                -
// - the aleph debugger main program                                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "System.hpp"
#include "Axdopts.hpp"
#include "Debugger.hpp"

// main interpreter 

int main (int argc, char** argv) {
  using namespace aleph;
  OutputTerm terr (OutputTerm::ERROR);

  // create a new option instance
  Axdopts* options = new Axdopts (argc,argv);

  // create a new debugger
  Debugger* dbg = new Debugger;

  // set some interpreter flags
  try {
    dbg->setassert  (options->getassert ());
    dbg->setemacs   (options->getemacs  ());
    dbg->setargs    (options->getargs   ());
    dbg->setpath    (options->getpath   ());
    dbg->setinitial (options->getfname  ());
  } catch (const Exception& e) {
    terr.errorln (e);
  } catch (...) {
    terr << "fatal: unknown exception trapped" << eolc;
    System::exit (1);
  }

  // loop in the debugger
  bool status = false;
  try {
    status = dbg->loop ();
  } catch (const Exception& e) {
    terr.errorln (e);
    System::exit (1);
  } catch (...) {
    terr << "fatal: unknown exception trapped" << eolc;
    System::exit (1);
  }

  // clean eveything and return
  delete options;
  delete dbg;
  return status ? 0 : 1;
}
