# ---------------------------------------------------------------------------
# - t_5500.als                                                              -
# - aleph:txt library test module                                           -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2003 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   print table test module
# @author amaury darsch

# get the library
interp:library "aleph-txt"

# create a simple print table
trans tbl (aleph:txt:PrintTable)
assert true (aleph:txt:print-table-p tbl)
assert 1    (tbl:get-columns)
assert 0    (tbl:get-rows)

# create a 2 columns table
trans tbl   (aleph:txt:PrintTable 2)
assert true (aleph:txt:print-table-p tbl)
assert 2    (tbl:get-columns)
assert 0    (tbl:get-rows)

# format column 0 to 20 / fill right
tbl:set-column-size 0 20
tbl:set-column-direction 0 true
tbl:set-column-direction 1 true

# add elements
tbl:add "Library"   "Nameset"
tbl:add "aleph-sio" "aleph:sio"
tbl:add "aleph-sys" "aleph:sys"
tbl:add "aleph-txt" "aleph:txt"
tbl:add "aleph-net" "aleph:net"
tbl:add "aleph-www" "aleph:www"

# check formatting
assert   20 (tbl:get-column-size 0)
assert    0 (tbl:get-column-size 1)
assert true (tbl:get-column-direction 0)
assert true (tbl:get-column-direction 1)

# check data
assert "Library"   (tbl:get 0 0)
assert "aleph-sio" (tbl:get 1 0)
assert "aleph:www" (tbl:get 5 1)
