// ---------------------------------------------------------------------------
// - Iterable.hpp                                                            -
// - standard object library - iterable abstract class definition            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_ITERABLE_HPP
#define  ALEPH_ITERABLE_HPP

#ifndef  ALEPH_ITERATOR_HPP
#include "Iterator.hpp"
#endif

namespace aleph {

  /// The Iterable class is an abstract class which define the virtual method
  /// "makeit" for a class which is potentially iterable. If an object is
  /// iterable, an iterator can be constructed for that object. Once the
  /// iterator is constructed, it is possible to iterate in this object.
  /// @author amaury darsch

  class Iterable : public virtual Object {
  public:
    /// @return a new iterator for this object
    virtual Iterator* makeit (void) =0;
  };
}

#endif
