// ---------------------------------------------------------------------------
// - Recycle.hpp                                                             -
// - standard object library - object recycling class definition             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_RECYCLE_HPP
#define  ALEPH_RECYCLE_HPP

#ifndef  ALEPH_CCNF_HPP
#include "ccnf.hpp"
#endif

#ifndef  ALEPH_MUTEX_HPP
#include "Mutex.hpp"
#endif

namespace aleph {
  
  /// The Recycle class is a reserved class used to recycle an object in
  /// an array instead of constructing it. Such class is designed to avoid
  /// the memory fragmentation. The class has also the ability to get
  /// resized in order to change the recycling depth. When the recycler is
  /// full, on the fly recycling is done.
  /// @author amaury darsch

  class Recycle {
  private:
    /// the recycler size
    long d_size;
    /// the number of pointers
    long d_plen;
    /// the recycled pointers
    void** p_rptr;
    /// the recycler mutex
    Mutex d_mtx;

  public:
    /// create a new recycle class
    Recycle (void);

    /// destroy this recycler
    ~Recycle (void);

    /// recycle a pointer
    /// @param ptr the pointer to recycle
    void push (void* ptr);

    /// get a new pointer or a recycled one
    void* pop (const t_size size);

  private:
    // make the copy constructor private
    Recycle (const Recycle&);
    // make the assignment operator private
    Recycle& operator = (const Recycle&);
  };
}

#endif
