parameter base 

switch $tcl_platform(platform)  {
	unix {	set history::base "~/.alicq/history" }
	windows {set history::base "c:/"}
} 

# Get from history
proc GetHistory {uin var} {
		upvar 1 $var history
		set fname [file join $history::base ${uin}.history]
		if {[catch {set fd [open $fname r]}]} return
		set history ""
		while {[gets $fd ln]!=-1} {
			if {[regexp {^\[ ([RS]).* ([0-9]+) \]$} $ln re dir utime]} {
				if {[info exists msg]} { 
					lappend history $msg
					set msg ""
				}
				set dir [expr ([string equal $dir "S"])?"outgoing":"incoming"]
				lappend history $dir $utime
				continue
			}
			if {[regexp {^:(.*)$} $ln re line]} {
				append msg $line "\n"
				continue
			}
		}
		if {[info exists msg]} { lappend history $msg }	
}
# Save message to history
proc Message {type UIN time Message} {
	catch {
		set fd [open [file join $history::base $UIN.history] a+]
		puts $fd "\[ $type | 0001 | 0270 | 0000 | $time \]"
		foreach ln [split $Message \n] { puts $fd ":$ln" }
		close $fd
	}
}

if {![file exists $history::base]} {file mkdir $history::base}

Hook IncomingMessage "history::Message R"
Hook OutgoingMessage "history::Message S"
Hook History "history::GetHistory"

