/*
    Copyright (C) 2006 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __XOVER2_H
#define __XOVER2_H


//--------------------------------------------------------------- 
//
//  Xover2 
// 
//  Second order crossover, outputs are exaclty in phase and
//  add up to a first order allpass.
//
//---------------------------------------------------------------

class Xover2
{
public:

    Xover2 (void) : _c0 (0), _c1 (0) { reset (); }
    ~Xover2 (void) {}

    void init (float fmid);
    void reset (void) { _z0 = _z1 = _z2 = 0; }
    void process (int k, float *in, float *lp, float *hp);

private:

    float    _c0, _c1;
    float    _z0, _z1, _z2;
};

#endif

