# Section D - How do statism and capitalism affect society?

This section of the FAQ indicates how both statism and capitalism affect the
society they exist in. It is a continuation of sections B ([Why do anarchists
oppose the current system?](secBcon.html)) and C ([What are the myths of
capitalist economics?](secCcon.html)) and it discusses the impact of the
underlying social and power relationships within the current system on
society.

This section is important because the institutions and social relationships
capitalism and statism spawn do not exist in a social vacuum, they have deep
impacts on our everyday lives. These effects go beyond us as individuals (for
example, the negative effects of hierarchy on our individuality) and have an
effect on how the political institutions in our society work, how technology
develops, how the media operates and so on. As such, it is worthwhile to point
out how (and why) statism and capitalism affect society as a whole outwith the
narrow bounds of politics and economics.

So here we sketch some of the impact concentrations of political and economic
power have upon society. While many people attack the **results** of these
processes (like specific forms of state intervention, ecological destruction,
imperialism, etc.) they usually ignore their **causes**. This means that the
struggle against social evils will be never-ending, like a doctor fighting the
symptoms of a disease without treating the disease itself or the conditions
which create it in the first place. We have indicated the roots of the
problems we face in earlier sections; now we discuss how these impact on other
aspects of our society. This section of the FAQ explores the interactions of
the causes and results and draws out how the authoritarian and exploitative
nature of capitalism and the state affects the world we live in.

It is important to remember that most supporters of capitalism refuse to do
this. Yes, some of them point out **some** flaws and problems within society
but they never relate them to the system as such. As Noam Chomsky points out,
they _"ignor[e] the catastrophes of capitalism or, on the rare occasions when
some problem is noticed, attribut[e] them to any cause **other** than the
system that consistently brings them about."_ [**Deterring Democracy**, p.
232] Thus we have people, say, attacking imperialist adventures while, at the
same time, supporting the capitalist system which drives it. Or opposing state
intervention in the name of "freedom" while supporting an economic system
which by its working forces the state to intervene simply to keep it going and
society together. The contradictions multiple, simply because the symptoms are
addressed, never the roots of the problems.

That the system and its effects are interwoven can best be seen from the fact
that while right-wing parties have been elected to office promising to reduce
the role of the state in society, the actual size and activity of the state
has not been reduced, indeed it has usually increased in scope (both in size
and in terms of power and centralisation). This is unsurprising, as "free
market" implies strong (and centralised) state -- the "freedom" of management
to manage means that the freedom of workers to resist authoritarian management
structures must be weakened by state action. Thus, ironically, state
intervention within society will continue to be needed in order to ensure that
society survives the rigours of market forces and that elite power and
privilege are protected from the masses.

The thing to remember is that the political and economic spheres are not
independent. They interact in many ways, with economic forces prompting
political reactions and changes, and vice versa. Overall, as Kropotkin
stressed, there are _"intimate links . . . between the political regime and
the economic regime."_ [**Words of a Rebel**, p. 118] These means that it is
impossible to talk of, say, capitalism as if it could exist without shaping
and being shaped by the state and society. Equally, to think that the state
could intervene as it pleased in the economy fails to take into account the
influence economic institutions and forces have on it. This has always been
the case, as the state _"is a hybridisation of political and social
institutions, of coercive with distributive functions, of highly punitive with
regulatory procedures, and finally of class with administrative needs -- this
melding process has produced very real ideological and practical paradoxes
that persist as major issues today."_ [Bookchin, **The Ecology of Freedom**,
p. 196] These paradoxes can only be solved, anarchists argue, by abolishing
the state and the social hierarchies it either creates (the state bureaucracy)
or defends (the economically dominant class). Until then, reforms of the
system will be incomplete, be subject to reversals and have unintended
consequences.

These links and interaction between statism and capitalism are to be expected
due to their similar nature. As anarchists have long argued, at root they are
based on the same hierarchical principle. Proudhon, for example, regarded
_"the capitalist principle"_ and _"the governmental principle"_ as _"one and
the same principle . . . abolition of the exploitation of man by man and the
abolition of the government of man by man, are one and the same formula."_
[quoted by Wayne Thorpe, **"The Workers Themselves"**, p. 279] This means that
anarchists reject the notion that political reforms are enough in themselves
and instead stress that they must be linked to (or, at least, take into
account) economic change. This means, for example, while we oppose specific
imperialist wars and occupation, we recognise that they will reoccur until
such time as the economic forces which generate them are abolished. Similarly,
we do not automatically think all attempts to reduce state intervention should
be supported simply because they appear to reduce the state. Instead, we
consider who is introducing the reforms, why they are doing so and what the
results will be. If the "reforms" are simply a case of politicians redirecting
state intervention away from the welfare state to bolster capitalist power and
profits, we would not support the change. Anarchist opposition to neo-
liberalism flows from our awareness of the existence of economic and social
power and inequality and its impact on society and the political structure.

In some ways, this section discusses class struggle **from above**, i.e. the
attacks on the working class conducted by the ruling class by means of its
state. While it appears that every generation has someone insisting that the
"class war" is dead and/or obsolete (Tony Blair did just that in the late
1990s), what they mean is that class struggle **from below** is dead (or, at
least, they wish it so). What is ignored is that the class struggle from above
continues even if class struggle from the below appears to have disappeared
(until it reappears in yet another form). This should be unsurprising as any
ruling class will be seeking to extend its profits, powers and privileges, a
task aided immensely by the reduced pressure from below associated with
periods of apparent social calm (Blair's activities in office being a striking
confirmation of this). Ultimately, while you may seek to ignore capitalism and
the state, neither will ignore you. That this produces resistance should be
obvious, as is the fact that demise of struggle from below have always been
proven wrong.

By necessity, this section will not (indeed, cannot) cover all aspects of how
statism and capitalism interact to shape both the society we live in and
ourselves as individuals. We will simply sketch the forces at work in certain
important aspects of the current system and how anarchists view them. Thus our
discussion of imperialism, for example, will not get into the details of
specific wars and interventions but rather give a broad picture of why they
happen and why they have changed over the years. However, we hope to present
enough detail for further investigation as well as an understanding of how
anarchists analyse the current system based on our anti-authoritarian
principles and how the political and economic aspects of capitalism interact.

[‹ Section D - How do statism and capitalism affect
society?](/afaq/secDcon.html "Go to previous page" ) [up](/afaq/secDcon.html
"Go to parent page" ) [D.1 Why does state intervention occur?
›](/afaq/secD1.html "Go to next page" )

